def solve_hex_operations():
    N = int(input().strip())

    grid = []
    for _ in range(2 * N - 1):
        row = list(map(int, input().strip().split()))
        grid.append(row)

    operations = input().strip()

    CENTER = N - 1

    def to_cube(r, c):
        z = r - CENTER
        x = c - CENTER + max(0, CENTER - r)
        y = -x - z
        return x, y, z

    def from_cube(x, y, z):
        r = z + CENTER
        c = x + CENTER - max(0, CENTER - r)
        return r, c

    R_M = [[0, -1, 0], [0, 0, -1], [-1, 0, 0]]
    L_M = [[0, 0, -1], [-1, 0, 0], [0, -1, 0]]
    T_M = [[0, 0, 1], [0, 1, 0], [1, 0, 0]]
    I_M = [[1, 0, 0], [0, 1, 0], [0, 0, 1]]

    def multiply_matrices(A, B):
        C = [[0, 0, 0], [0, 0, 0], [0, 0, 0]]
        for i in range(3):
            for j in range(3):
                for k in range(3):
                    C[i][j] += A[i][k] * B[k][j]
        return C

    M_final = I_M
    for op in reversed(operations):
        if op == 'R':
            M_op = R_M
        elif op == 'L':
            M_op = L_M
        elif op == 'T':
            M_op = T_M
        else:
            continue
        M_final = multiply_matrices(M_final, M_op)

    final_cells = {}
    for r_orig in range(2 * N - 1):
        for c_orig, value in enumerate(grid[r_orig]):
            x_orig, y_orig, z_orig = to_cube(r_orig, c_orig)
            v_orig = [x_orig, y_orig, z_orig]

            v_final = [0, 0, 0]
            for i in range(3):
                for j in range(3):
                    v_final[i] += M_final[i][j] * v_orig[j]

            x_final, y_final, z_final = v_final
            r_final, c_final = from_cube(x_final, y_final, z_final)

            if r_final not in final_cells:
                final_cells[r_final] = []
            final_cells[r_final].append((c_final, value))

    output = []
    for r in range(2 * N - 1):
        if r in final_cells:
            final_cells[r].sort(key=lambda item: item[0])
            row_output = [str(item[1]) for item in final_cells[r]]
            output.append(" ".join(row_output))
        else:
            output.append("")

    while output and not output[-1]:
        output.pop()

    print("\n".join(output))


if __name__ == "__main__":
    solve_hex_operations()