#include <bits/stdc++.h>
using namespace std;

const long long MOD = 1e9 + 7;

long long mod_pow(long long a, long long b) {
    long long res = 1;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

long long mod_inv(long long x) {
    return mod_pow(x, MOD - 2);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int t;
    cin >> t;
    
    while (t--) {
        long long p, m;
        cin >> p >> m;
        
        long long n = 2 * p + m;
        
        long long result = 1;
        for (long long i = 1; i <= p; i++) {
            long long term = mod_inv(n - 2 * i + 1);
            result = (result + term) % MOD;
        }
        result = result * (m + 1) % MOD;
        
        cout << result << '\n';
    }
    
    return 0;
}