#include <iostream>
#include <vector>
#include <climits>
#include <cmath>
#include <algorithm>

using namespace std;

typedef long long ll;

int main() {
    int n;
    cin >> n;

    vector<ll> x(n), y(n);
    for (int i = 0; i < n; ++i) {
        cin >> x[i] >> y[i];
    }

    if (n == 2) {
   
        ll dx = x[1] - x[0];
        ll dy = y[1] - y[0];

        ll a = dy;
        ll b = -dx;

        ll c1 = -a * x[0] - b * y[0];

        ll c2 = -a * x[1] - b * y[1];
        cout << a << " " << b << " " << c1 << endl;
        cout << a << " " << b << " " << c2 << endl;
        return 0;
    }

    ll best_width = -1;
    ll best_a = 0, best_b = 0, best_c1 = 0, best_c2 = 0;

    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            ll dx = x[j] - x[i];
            ll dy = y[j] - y[i];

            ll a = dy;
            ll b = -dx;


            if (a == 0 && b == 0) continue;


            vector<ll> f(n);
            for (int k = 0; k < n; ++k) {
                f[k] = a * x[k] + b * y[k];
            }

            ll min_f = *min_element(f.begin(), f.end());
            ll max_f = *max_element(f.begin(), f.end());
            ll width = max_f - min_f;

            if (width > best_width) {
                best_width = width;
                best_a = a;
                best_b = b;
                best_c1 = -min_f;
                best_c2 = -max_f;
            }


            a = -dy;
            b = dx;

            for (int k = 0; k < n; ++k) {
                f[k] = a * x[k] + b * y[k];
            }

            min_f = *min_element(f.begin(), f.end());
            max_f = *max_element(f.begin(), f.end());
            width = max_f - min_f;

            if (width > best_width) {
                best_width = width;
                best_a = a;
                best_b = b;
                best_c1 = -min_f;
                best_c2 = -max_f;
            }
        }
    }

    cout << best_a << " " << best_b << " " << best_c1 << endl;
    cout << best_a << " " << best_b << " " << best_c2 << endl;

    return 0;
}