#include <iostream>
#include <vector>
#include <algorithm>
#include <cctype>
using namespace std;

typedef long long ll;

struct Point {
    ll x, y;
    bool operator<(const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
    bool operator==(const Point& p) const {
        return x == p.x && y == p.y;
    }
};

ll cross(const Point& O, const Point& A, const Point& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Point> convex_hull(vector<Point> pts) {
    int n = pts.size();
    if (n <= 1) return pts;
    sort(pts.begin(), pts.end());
    auto last = unique(pts.begin(), pts.end());
    pts.erase(last, pts.end());
    n = pts.size();

    vector<Point> hull;
    hull.reserve(2 * n);


    for (int i = 0; i < n; ++i) {
        while (hull.size() >= 2) {
            Point& A = hull[hull.size() - 2];
            Point& B = hull[hull.size() - 1];
            if (cross(A, B, pts[i]) <= 0) hull.pop_back();
            else break;
        }
        hull.push_back(pts[i]);
    }

    int lower_len = hull.size();

    for (int i = n - 2; i >= 0; --i) {
        while ((int)hull.size() > lower_len) {
            Point& A = hull[hull.size() - 2];
            Point& B = hull[hull.size() - 1];
            if (cross(A, B, pts[i]) <= 0) hull.pop_back();
            else break;
        }
        hull.push_back(pts[i]);
    }

    if (hull.size() > 1) hull.pop_back(); 
    return hull;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<Point> points(n);
    vector<ll> x(n), y(n);
    for (int i = 0; i < n; ++i) {
        cin >> points[i].x >> points[i].y;
        x[i] = points[i].x;
        y[i] = points[i].y;
    }

    if (n == 1) {
        cout << "1 0 " << -x[0] << "\n1 0 " << -x[0] << "\n";
        return 0;
    }

    auto hull = convex_hull(points);
    int h = hull.size();



    ll best_width = -1;
    ll best_a = 1, best_b = 0, best_c1 = 0, best_c2 = 0;


    for (int i = 0; i < h; ++i) {
        for (int j = 0; j < h; ++j) {
            if (i == j) continue;
            ll a = hull[j].x - hull[i].x;
            ll b = hull[j].y - hull[i].y;
            if (a == 0 && b == 0) continue;

            ll min_f = (ll)9e18;
            ll max_f = (ll)-9e18;

            for (int k = 0; k < n; ++k) {
                ll f = a * x[k] + b * y[k];
                if (f < min_f) min_f = f;
                if (f > max_f) max_f = f;
            }

            ll width = max_f - min_f;
            if (width > best_width) {
                best_width = width;
                best_a = a;
                best_b = b;
                best_c1 = -min_f;
                best_c2 = -max_f;
            }
        }
    }

    cout << best_a << " " << best_b << " " << best_c1 << "\n";
    cout << best_a << " " << best_b << " " << best_c2 << "\n";

    return 0;
}