#include <iostream>
#include <vector>

using namespace std;

const int MOD = 999983;
const int MUL = 618023;

struct FastBitset {
    vector<uint64_t> data;
    int size;

    FastBitset(int n) : size(n) {
        data.resize((n + 63) / 64, 0);
    }

    void set(int pos) {
        data[pos >> 6] |= (1ULL << (pos & 63));
    }

    bool test(int pos) const {
        return (data[pos >> 6] >> (pos & 63)) & 1;
    }

    void xor_range(int start, const FastBitset& other, int other_shift = 0) {
        int block_start = start >> 6;
        int bit_shift = start & 63;
        int blocks = other.data.size();

        for (int i = 0; i < blocks; i++) {
            uint64_t val = other.data[i];
            if (other_shift) {
                val = (val << other_shift) | (i > 0 ? (other.data[i - 1] >> (64 - other_shift)) : 0);
            }

            int target_block = block_start + i;
            if (target_block >= data.size()) break;

            if (bit_shift == 0) {
                data[target_block] ^= val;
            }
            else {
                data[target_block] ^= (val << bit_shift);
                if (target_block + 1 < data.size()) {
                    data[target_block + 1] ^= (val >> (64 - bit_shift));
                }
            }
        }
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, s;
    cin >> n >> s;

    vector<int> sequence(n);
    for (int i = 0; i < n; i++) {
        s = (int)((1LL * s * MUL + 1) % MOD);
        sequence[i] = s;
    }

    FastBitset inV(MOD);
    FastBitset flip(MOD);
    int count = 0;

    for (int step = 0; step < n; step++) {
        int cur = sequence[step];

        bool should_add = !flip.test(cur);
        if (cur % 2 == 0 && inV.test(cur / 2)) {
            should_add = !should_add;
        }

        if (should_add && !inV.test(cur)) {
            inV.set(cur);
            count++;

            flip.xor_range(cur, inV);
        }
    }

    cout << count;
    return 0;
}