#include <iostream>
#include <vector>
#include <algorithm>
#include <bitset>
using namespace std;

const int MOD = 999983;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, s;
    cin >> n >> s;
    bitset<MOD> inV;
    vector<short> small_V;
    vector<int> large_V;
    bool use_small = true;
    for (int i = 0; i < n; i++) {
        s = (1LL * s * 618023 + 1) % MOD;
        int count = 0;
        
        if (use_small) {
            for (size_t j = 0; j < small_V.size(); j++) {
                int a = small_V[j];
                int b = s - a;
                if (b >= 0 && b < MOD && inV[b] && a <= b) {
                    count++;
                }
            }
            
            if (count % 2 == 0 && !inV[s]) {
                inV.set(s);
                small_V.push_back(s);
                sort(small_V.begin(), small_V.end());

                if (small_V.size() > 5000) {
                    large_V.assign(small_V.begin(), small_V.end());
                    use_small = false;
                }
            }
        } else {
            int left = 0, right = (int)large_V.size() - 1;
            while (left <= right) {
                int sum = large_V[left] + large_V[right];
                if (sum == s) {
                    count += (left == right) ? 1 : 2;
                    left++;
                    right--;
                } else if (sum < s) {
                    left++;
                } else {
                    right--;
                }
            }
            
            if (count % 2 == 0 && !inV[s]) {
                inV.set(s);
                auto it = lower_bound(large_V.begin(), large_V.end(), s);
                large_V.insert(it, s);
            }
        }
    }
    
    cout << (use_small ? small_V.size() : large_V.size()) << "\n";
    return 0;
}