#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
using namespace std;

struct Point {
    long long x, y;
};
Point p0;

long long cross_product(Point a, Point b, Point c) {
    return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}

long long dist_sq(Point a, Point b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

bool compare_points(Point p1, Point p2) {
    long long cp = cross_product(p0, p1, p2);
    if (cp == 0)
        return dist_sq(p0, p1) < dist_sq(p0, p2);
    return cp > 0;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n; cin >> n;
    vector<Point> points(n);

    int p0_idx = 0;
    for (int i = 0; i < n; ++i) {
        cin >> points[i].x >> points[i].y;
        if (points[i].y < points[p0_idx].y || 
            points[i].y == points[p0_idx].y && points[i].x < points[p0_idx].x)
            p0_idx = i;
    }
    swap(points[0], points[p0_idx]);
    p0 = points[0];

    sort(points.begin() + 1, points.end(), compare_points);
    vector<Point> hull = { points[0] };
    for (int i = 1; i < n; ++i) {
        while (hull.size() >= 2 &&
               cross_product(hull[hull.size()-2], hull.back(), points[i]) <= 0)
            hull.pop_back();
        hull.push_back(points[i]);
    }

    if (hull.size() < 3) {
        Point p1 = hull.front(), p2 = hull.back();
        long long a = p2.x - p1.x, b = p2.y - p1.y;
        long long v_min = -1, v_max = -1;
    
        bool first = true;
        for(const auto& p : points) {
            long long v = a * p.x + b * p.y;
            if (first) {
                v_min = v; v_max = v;
                first = false;
            } else {
                v_min = min(v_min, v);
                v_max = max(v_max, v);
            }
        }
        cout << a << " " << b << " " << -v_max << endl;
        cout << a << " " << b << " " << -v_min << endl;
        return 0;
    }

    long long h = hull.size();
    long double max_dist_sq = -1.0;
    long long best_a = 0, best_b = 0, best_c1 = 0, best_c2 = 0;

    for (int i = 0; i < h; ++i) {
        int min_k = i, max_k = i;
        for (int j = i + 1; j < h; ++j) {
            long long a = hull[j].x - hull[i].x;
            long long b = hull[j].y - hull[i].y;
            
            auto val = [&](int k) { return a * hull[k].x + b * hull[k].y; };

            while (val(min_k) > val((min_k - 1 + h) % h)) min_k = (min_k - 1 + h) % h;
            while (val(max_k) < val((max_k + 1) % h)) max_k = (max_k + 1) % h;
            
            long long v_min = val(min_k);
            long long v_max = val(max_k);
            long long den_sq = a * a + b * b;

            if (den_sq > 0) {
                long double num_sq = static_cast<long double>((v_max - v_min) * (v_max - v_min));
                if (num_sq / den_sq > max_dist_sq) {
                    max_dist_sq = num_sq / den_sq;
                    best_a = a; best_b = b;
                    best_c1 = -v_max; best_c2 = -v_min;
                }
            }
        }
    }

    int antiK = 1;
    for (int i = 0; i < h; ++i) {
        int i1 = (i + 1) % h;
        long long a = hull[i1].y - hull[i].y;
        long long b = -(hull[i1].x - hull[i].x);

        auto area_abs = [&](int k) {
            return abs(cross_product(hull[i], hull[i1], hull[k]));
        };

        while (area_abs(antiK) < area_abs((antiK + 1) % h))
            antiK = (antiK + 1) % h;

        long long v1 = a * hull[i].x + b * hull[i].y;
        long long v2 = a * hull[antiK].x + b * hull[antiK].y;
        long long den_sq = a * a + b * b;
        if (den_sq > 0) {
            long double num_sq = (long double)(v1 - v2) * (v1 - v2);
            if (num_sq / den_sq > max_dist_sq) {
                max_dist_sq = num_sq / den_sq;
                best_a = a; best_b = b;
                best_c1 = -v1; best_c2 = -v2;
            }
        }
    }

    cout << best_a << " " << best_b << " " << best_c1 << endl;
    cout << best_a << " " << best_b << " " << best_c2 << endl;

    return 0;
}