fun main() {
    val line = readln().trim().split(" ").map { it.toDouble() }
    val n = line[0]
    val p = line[1]

    val currentTotal = n * 12

    val progressiveTotal = countProgressive(p, n)

    val difference = progressiveTotal - currentTotal
    println("%.6f".format(difference).replace(",", "."))
}

fun countProgressive(p: Double, n: Double): Double {
    var total = 0.0
    val monthlyIncrement = (p / 12) / 100

    for (month in 0 until 12) {
        val salary = n * (1 + month * monthlyIncrement)
        total += salary
    }

    return total
}

// 4346 1