def can_play(melody):
    notes = "ABCDEFG" * 8
    notes = notes[:52]

    reachable = set(i for i in range(52) if notes[i] == melody[0])

    for ch in melody[1:]:
        next_reachable = set()
        for pos in reachable:
            for new_pos in range(max(0, pos - 3), min(52, pos + 4)):
                if notes[new_pos] == ch:
                    next_reachable.add(new_pos)
        reachable = next_reachable
        if not reachable:
            return False
    return True


def main():
    t = int(input())
    for _ in range(t):
        s = input().strip()
        print("YES" if can_play(s) else "NO")


if __name__ == "__main__":
    main()