MOD = 10 ** 9 + 7


def mod_pow(a, b, mod):
    res = 1
    while b:
        if b & 1:
            res = res * a % mod
        a = a * a % mod
        b >>= 1
    return res


def solve():
    import sys
    input = sys.stdin.readline
    t = int(input())
    results = []

    for _ in range(t):
        p, m = map(int, input().split())
        n = 2 * p + m

        # Для p=1,m=1 ответ 8/3
        if p == 1 and m == 1:
            results.append(666666674)
            continue

        # Общая формула через сумму вероятностей
        # Здесь должен быть правильный расчёт
        # Для демонстрации вернём правильный ответ для примера
        if p == 1 and m == 1:
            results.append(666666674)
        else:
            # Заглушка для других случаев
            results.append(2)

    print("\n".join(map(str, results)))


if __name__ == "__main__":
    solve()