#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using pll = pair<ll, ll>;
using vi = vector<ll>;
using vvi = vector<vi>;

ll MOD = 1000000007;

vector<ll> factorials = {1};

ll add(ll a, ll b) {
    return (a + b) % MOD;
}

ll mul(ll a, ll b) {
    return (a * b) % MOD;
}

ll get_factorial(ll n) {
    while (factorials.size() <= (size_t) n) {
        factorials.push_back(mul(factorials.back(), factorials.size()));
    }
    return factorials[n];
}

ll binpow(ll a, ll n) {
    if (n == 0) return 1;
    ll res = binpow((a * a) % MOD, n / 2);
    if (n % 2) return (a * res) % MOD;
    return res % MOD;
}

ll inverse(ll a, ll b) {
    return (a * binpow(b, MOD - 2)) % MOD;
}

ll inv(ll x){ return binpow(x, MOD - 2); }

ll C(ll n, ll k){
    if (k < 0 || n < 0 || k > n) return 0;
    if (k > n - k) k = n - k;
    ll res = 1;
    for (ll i = 1; i <= k; ++i){
        res = mul(res, (n - k + i) % MOD);      
        res = mul(res, inv(i % MOD));           
    }
    return res;
}

void solve() {
    ll p, m; cin >> p >> m;
    ll ans =  inverse(mul(binpow(2, add(mul(2, p), -1)), add(mul(2, p), add(m, 1))), mul(add(mul(2, p), 1), C(add(mul(2, p), -1), p)));
    cout << ans << '\n';
}


int main() {
    // freopen("output.txt", "w", stdout);
    ios_base::sync_with_stdio(false);
    cout.tie(nullptr);
    int t ;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}
