#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>
#include <string>
#include <random>
#include <typeinfo>
#include <map>
#include <set>
#include <cassert>
#include <queue>
#include <unordered_map>
#include <functional>

using std::cin, std::cout, std::cerr, std::endl;
using std::vector, std::queue, std::deque, std::array, std::string,
        std::map, std::set, std::unordered_map, std::tuple;
using std::istream, std::ostream;
using std::min, std::max;
using std::abs, std::sort;

template<typename T, typename V = T>
using pair = std::pair<T, V>;

// #pragma GCC optimize("O3")
// #pragma GCC optimize("unroll-loops")
// #pragma GCC target("avx2,popcnt,tune=native")

using ll = long long;
using ull = unsigned long long;
using dl = long double;

#define all(x) (x).begin(), (x).end()

template<typename T>
std::ostream &operator<<(std::ostream &out, const pair<T, T> &a) {
    out << '(' << a.first << ' ' << a.second << ')';
    return out;
}

template<typename T, typename V>
std::istream &operator>>(std::istream &in, pair<T, V> &a) {
    in >> a.first >> a.second;
    return in;
}

template<typename T>
std::istream &operator>>(std::istream &in, vector<T> &a) {
    for (size_t i = 0; i < a.size(); i++) {
        in >> a[i];
    }
    return in;
}

struct int_mod;

//template<typename T>
//concept StringLike = std::same_as<std::remove_cvref_t<T>, std::string> ||
//                     std::convertible_to<T, std::string_view>;
//
//template<typename T>
//concept Iterable = std::ranges::range<T> && (!StringLike<T>);
//
//template<Iterable Container>
//std::ostream &operator<<(std::ostream &out, const Container &container) {
//    using value_type = std::decay_t<decltype(*std::begin(container))>;
//
//    char separator = (std::is_arithmetic_v<value_type> || std::is_same_v<value_type, int_mod>)
//                     ? ' '
//                     : '\n';
//
//    for (const auto &i: container) {
//        out << i << separator;
//    }
//    return out;
//}

// c++17 version
template<typename T>
std::ostream &operator<<(std::ostream &out, const vector<T> &container) {
    char separator = (std::is_arithmetic_v<T> || std::is_same_v<T, int_mod>)
                     ? ' '
                     : '\n';

    for (const auto &i: container) {
        out << i << separator;
    }
    return out;
}

template<typename T>
bool mini(T &a, const T &b) {
    if (a > b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
bool maxi(T &a, const T &b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
T binpow(const T &a, ll exp) {
    T res(1);
    T base = a;
    while (exp > 0) {
        if (exp & 1)
            res *= base;
        base *= base;
        exp /= 2;
    }
    return res;
}

struct int_mod {
    static const int MOD = 998'244'353;
private:
    int val;

public:
    int_mod() : val(0) {}

    int_mod(int x) {
        val = (x % MOD + MOD) % MOD;
    }

    int_mod(ll x) {
        val = (int) ((x % MOD + MOD) % MOD);
    }

    operator int() const {
        return val;
    }

    int_mod &operator+=(const int_mod &other) {
        val += other.val;
        if (val >= MOD)
            val -= MOD;
        return *this;
    }

    int_mod &operator-=(const int_mod &other) {
        val -= other.val;
        if (val < 0)
            val += MOD;
        return *this;
    }

    int_mod &operator*=(const int_mod &other) {
        val = static_cast<int>(static_cast<long long>(val) * other.val % MOD);
        return *this;
    }

    int_mod &operator/=(const int_mod &other) {
        return *this *= other.inv();
    }

    int_mod inv() const {
        return binpow(*this, MOD - 2);
    }

    friend int_mod operator+(int_mod a, const int_mod &b) {
        a += b;
        return a;
    }

    friend int_mod operator+(int_mod a, int b) {
        a += b;
        return a;
    }

    friend int_mod operator-(int_mod a, const int_mod &b) {
        a -= b;
        return a;
    }

    friend int_mod operator-(int_mod a, int b) {
        a -= b;
        return a;
    }

    friend int_mod operator*(int_mod a, const int_mod &b) {
        a *= b;
        return a;
    }

    friend int_mod operator*(int_mod a, int b) {
        a *= b;
        return a;
    }

    friend int_mod operator/(int_mod a, const int_mod &b) {
        a /= b;
        return a;
    }

    friend int_mod operator/(int_mod a, int_mod b) {
        a /= b;
        return a;
    }

    friend std::ostream &operator<<(std::ostream &os, const int_mod &m) {
        return os << m.val;
    }

    friend std::istream &operator>>(std::istream &is, int_mod &m) {
        int x;
        is >> x;
        m = int_mod(x);
        return is;
    }
};

ll rev(ll x) {
    vector<ll> a;
    while (x > 0) {
        a.push_back(x & 1);
        x /= 2;
    }
    ll r = 0;
    for (auto i : a) {
        r *= 2;
        r += i;
    }
    return r;
}

void solve() {
    ll n;
    cin >> n;
    int ans = 0;
    while (n > 0) {
        n = rev(n) - 1;
        ans++;
    }
    cout << ans;
}

signed main() {
#ifdef pskobx
    freopen("input", "r", stdin);
    freopen("out", "w", stdout);
#endif
#ifndef pskobx
    std::ios::sync_with_stdio(false);
    cin.tie(nullptr);
#endif

    int tests = 1;
//    cin >> tests;

    while (tests--) {
        solve();
        cout << '\n';
    }
}

