#include <cmath>
#include <iostream>
#include <limits>

struct point {
  int x;
  int y;
};

double distance(point x, point y) {
  double a = (x.x - y.x);
  double b = (x.y - y.y);
  double c1 = 0;
  double c2 = - a * a - b;
  return std::abs(c2 / std::sqrt(a * a + 1));
}

void print(point x, point y) {
  double a = (x.x - y.x);
  double b = (x.y - y.y);
  double c1 = 0;
  double c2 = - a * a - b;
  std::cout << a << " " << b << " " << c1 << "\n";
  std::cout << a << " " << b << " " <<  c2 << "\n";
}

int main() {
  int n;
  std::cin >> n;
  point maxPointX{std::numeric_limits<int>::min(), 0}, minPointX{std::numeric_limits<int>::max(), 0};
  point maxPointY{0, std::numeric_limits<int>::min()}, minPointY{0, std::numeric_limits<int>::max()};
  for (size_t i = 0; i < n; ++i) {
    int x, y;
    std::cin >> x >> y;
    if (x > maxPointX.x) {
      maxPointX = {x, y};
    }
    if (x < minPointX.x) {
      minPointX = {x, y};
    }
    if (y > maxPointY.y) {
      maxPointY = {x, y};
    }
    if (y < minPointY.y) {
      minPointY = {x, y};
    }
  }
  auto distance1 = distance(maxPointX, minPointX);
  auto distance2 = distance(maxPointY, minPointY);
  if (distance1 >= distance2) {
    print(maxPointX, minPointX);
  } else {
    print(maxPointY, minPointY);
  }
}