#include <bits/stdc++.h>

using namespace std;

struct Point {
 
    long long x;
 
    long long y;
 
    int id;
 
    int type;
 
    Point()
    {}
 
    Point(long long x, long long y)
        : x(x)
        , y(y)
        , type(y > 0 || (y == 0 && x >= 0))
    {}
 
    static Point read() {
        long long x, y;
        cin >> x >> y;
        return {x, y};
    }
 
    long long getLen2() const {
        return x * x + y * y;
    }
 
    double getLen() const {
        return sqrt(getLen2());
    }

    double dist(const Point &r) const {
        return sqrt((double) (r.x - x) * (r.x - x) + (r.y - y) * (r.y - y));
    }
 
    bool operator ==(const Point &a) const {
        return x == a.x && y == a.y;
    }
 
    Point operator +(const Point &a) const {
        return Point{x + a.x, y + a.y};
    }
 
    Point operator -(const Point &a) const {
        return Point{x - a.x, y - a.y};
    }
 
    Point operator *(long long a) const {
        return Point{x * a, y * a};
    }
 
    long long operator *(const Point &a) const {
        return x * a.x + y * a.y;
    }
 
    long long operator %(const Point &a) const {
        return x * a.y - a.x * y;
    }
 
    double getAngle(const Point &a) const {
        return acos(*this * a * 1.0 / getLen() / a.getLen());
    }
};

int main() {
    cin.tie(0);
    ios::sync_with_stdio(0);
    int n;
    cin >> n;
    vector<Point> points(n);
    for (int i = 0; i < n; i++) {
        points[i] = Point::read();
    }
    vector<int> far(n);
    for (int i = 0; i < n; i++) {
        double maxx = 0;
        for (int j = 0; j < n; j++) {
            double dist = points[i].dist(points[j]);
            if (maxx < dist){
                far[i] = j;
                maxx = dist;
            }
        }
    }
    double max_dist = 0;
    vector<long long> line1;
    vector<long long> line2;
    for (int i = 0; i < n; i++) {
        Point f = points[i], s = points[far[i]];
        int signB = 1;
        if (f.y != s.y) {
            signB = (f.y - s.y) / abs(f.y - s.y);
        }
        long long a = (f.x - s.x) * signB, b = (f.y - s.y) * signB;
        long long biggerC = (-a * f.x - b * f.y);
        long long lesserC = (-a * s.x - b * s.y);
        if (biggerC < lesserC) {
            swap(biggerC, lesserC);
        }
        bool correct = true;
        for (int j = 0; j < n; j++) {
            Point check = points[j];
            if (check.x * a + check.y * b + biggerC < 0 || check.x * a + check.y * b + lesserC > 0) {
                correct = false;
                break;
            }
        }
        if (correct) {
            double dist = f.dist(s);
            if (dist > max_dist) {
                max_dist = dist;
                line1 = {a, b, biggerC};
                line2 = {a, b, lesserC};
            }
        }
    }
    for (long long a: line1) {
        cout << a << ' ';
    }
    cout << '\n';
    for (long long a: line2) {
        cout << a << ' ';
    }
    return 0;
}