#include <algorithm>
#include <cmath>
#include <iostream>
#include <numeric>
#include <vector>

template <typename T = long long>
struct dot {
    T x, y;

    T abs() const
    {
        return x * x + y * y;
    }

    dot operator-(dot const &rhs) const
    {
        return dot { .x = x - rhs.x, .y = y - rhs.y };
    }

    T operator%(dot const &rhs) const
    {
        return x * rhs.y - y * rhs.x;
    }
};

struct line {
    long long a, b, c;

    void set_guide(dot<> const &s)
    {
        a = -s.y;
        b = s.x;
    }

    void set_normal(dot<> const &n)
    {
        a = n.x;
        b = n.y;
    }

    void set_dot(dot<> const &p)
    {
        c = -(a * p.x + b * p.y);
    }

    long long value(dot<> const &p)
    {
        long long g = std::gcd(std::gcd(a, b), c);
        a /= g;
        b /= g;
        c /= g;
        return p.x * a + p.y * b + c;
    }

    long double distance(dot<> const &p)
    {
        dot<long double> pd;
        pd.x = p.x;
        pd.y = p.y;
        dot<long double> s;
        s.x = -b;
        s.y = a;
        dot<long double> m = {};
        if (a) {
            m.y = 0;
            m.x = (long double)-c / a;
        } else if (b) {
            m.x = 0;
            m.y = (long double)-c / b;
        }
        return std::abs(((pd - m) % s)) / std::sqrt(s.abs());
    }
};

int main()
{
    int n;
    std::cin >> n;
    std::vector<dot<>> a(n);
    for (auto &&[x, y] : a) {
        std::cin >> x >> y;
    }
    for (int i = 1; i < n; ++i) {
        if (a[i].x < a[0].x || a[i].x == a[0].x && a[i].y < a[0].y) {
            std::swap(a[0], a[i]);
        }
    }
    std::sort(a.begin() + 1, a.end(), [&](dot<> const &lhs, dot<> const &rhs) {
        dot<> f = lhs - a[0], s = rhs - a[0];
        if (f % s == 0)
            return f.abs() < s.abs();
        return f % s > 0;
    });
    std::vector<dot<>> hull { a[0] };
    for (int i = 1; i < a.size(); ++i) {
        for (; hull.size() > 1;) {
            dot<> prev = hull.back() - hull[hull.size() - 2];
            dot<> cur = a[i] - hull.back();
            if (prev % cur <= 0)
                hull.pop_back();
            else
                break;
        }
        hull.push_back(a[i]);
    }
    a = hull;
    long double result = 0;
    line        res1, res2;
    for (int i = 0; i < a.size(); ++i) {
        for (int j = i + 1; j < a.size(); ++j) {
            auto check = [&](line &l, int i) {
                int next = (i + 1) % a.size();
                int prev = (i - 1 + a.size()) % a.size();
                return l.value(a[next]) * l.value(a[prev]) >= 0;
            };
            dot<> sn = (a[j] - a[i]);
            std::swap(sn.x, sn.y);
            sn.x = -sn.x;
            line l1, l2;
            l1.set_guide(sn);
            l1.set_dot(a[i]);
            l2.set_guide(sn);
            l2.set_dot(a[j]);
            if (!check(l1, i) || !check(l2, j))
                continue;
            long double dist = l1.distance(a[j]);
            if (result < dist) {
                result = dist;
                res1 = l1;
                res2 = l2;
            }
        }
    }
    std::cout << res1.a << " " << res1.b << " " << res1.c << "\n";
    std::cout << res2.a << " " << res2.b << " " << res2.c << "\n";
}
