#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

typedef long long ll;

const int MOD = 1000000007;

ll mod_pow(ll base, ll exp, ll mod)
{
    ll result = 1;
    while (exp > 0)
    {
        if (exp % 2 == 1)
        {
            result = (result * base) % mod;
        }
        base = (base * base) % mod;
        exp /= 2;
    }
    return result;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;
    vector<pair<int, int>> pairs(t);

    int maxp = 0;
    for (int i = 0; i < t; i++)
    {
        int p, m;
        cin >> p >> m;
        pairs[i] = {p, m};
        maxp = max(maxp, p);
    }

    if (maxp == 0)
    {
        for (int i = 0; i < t; i++)
        {
            cout << 0 << "\n";
        }
        return 0;
    }

    int n = 2 * maxp;
    vector<long long> fact(n + 1);
    vector<long long> invfact(n + 1);

    fact[0] = 1;
    for (int i = 1; i <= n; i++)
    {
        fact[i] = fact[i - 1] * i % MOD;
    }

    invfact[n] = mod_pow(fact[n], MOD - 2, MOD);
    for (int i = n; i > 0; i--)
    {
        invfact[i - 1] = invfact[i] * i % MOD;
    }

    for (auto &pair : pairs)
    {
        int p = pair.first;
        int m = pair.second;

        if (p == 0)
        {
            cout << 0 << "\n";
            continue;
        }

        ll C = fact[2 * p - 1] * invfact[p - 1] % MOD;
        C = C * invfact[p] % MOD;

        ll ans = mod_pow(2, 2 * p - 1, MOD);
        ans = ans * mod_pow(C, MOD - 2, MOD) % MOD;
        ans = ans * (m + 2LL * p + 1) % MOD;
        ans = ans * mod_pow(2 * p + 1, MOD - 2, MOD) % MOD;

        cout << ans << "\n";
    }

    return 0;
}