#include <cstdint>
#include <iostream>
#include <vector>
#include <string>


#pragma GCC optimize("O2")
#pragma GCC optimize("unroll-loops")
#define enable_fast_io std::ios::sync_with_stdio(false); std::cin.tie(nullptr);


void convert_matrix_to_gex(const size_t level, const std::vector<std::vector<size_t>> &matrix, std::vector<std::vector<size_t>> &gex) {
    const size_t n = gex.size();
    const size_t edge_size = n - level - 1;

    if (edge_size == 0) {
        gex[level].push_back(matrix[level][level]);
        return;
    }


    const size_t i1 = level,                j1 = n - 1;
    const size_t i2 = n - 1,                j2 = 2 * n - 2 - level;
    const size_t i3 = 2 * n - 2 - level,    j3 = n - 1;
    const size_t i4 = 2 * n - 2 - level,    j4 = level;
    const size_t i5 = n - 1,                j5 = level;
    const size_t i6 = level,                j6 = level;

    size_t i, j, d;
    for (d = 0, i = i1, j = j1; d < edge_size; ++d, ++i, ++j) {
        gex[level].push_back(matrix[i][j]);
    }

    for (d = 0, i = i2, j = j2; d < edge_size; ++d, ++i, --j) {
        gex[level].push_back(matrix[i][j]);
    }

    for (d = 0, i = i3, j = j3; d < edge_size; ++d, --j) {
        gex[level].push_back(matrix[i][j]);
    }

    for (d = 0, i = i4, j = j4; d < edge_size; ++d, --i) {
        gex[level].push_back(matrix[i][j]);
    }

    for (d = 0, i = i5, j = j5; d < edge_size; ++d, --i) {
        gex[level].push_back(matrix[i][j]);
    }

    for (d = 0, i = i6, j = j6; d < edge_size; ++d, ++j) {
        gex[level].push_back(matrix[i][j]);
    }
}


void convert_gex_to_matrix(const size_t level, const std::vector<std::vector<size_t>> &gex, const size_t start, const bool swap, std::vector<std::vector<size_t>> &matrix) {
    const size_t n = gex.size();
    const size_t edge_size = n - level - 1;

    if (edge_size == 0) {
        matrix[level][level] = gex[level][0];
        return;
    }

    const size_t i1 = level,                j1 = n - 1;
    const size_t i2 = n - 1,                j2 = 2 * n - 2 - level;
    const size_t i3 = 2 * n - 2 - level,    j3 = n - 1;
    const size_t i4 = 2 * n - 2 - level,    j4 = level;
    const size_t i5 = n - 1,                j5 = level;
    const size_t i6 = level,                j6 = level;

    size_t i, j, d, cur = start;
    for (d = 0, i = i1, j = j1; d < edge_size; ++d, ++i, ++j) {
        matrix[i][j] = gex[level][cur];
        cur = ((cur + gex[level].size() + (swap ? -1 : 1)) % gex[level].size());
    }

    for (d = 0, i = i2, j = j2; d < edge_size; ++d, ++i, --j) {
        matrix[i][j] = gex[level][cur];
        cur = ((cur + gex[level].size() + (swap ? -1 : 1)) % gex[level].size());
    }

    for (d = 0, i = i3, j = j3; d < edge_size; ++d, --j) {
        matrix[i][j] = gex[level][cur];
        cur = ((cur + gex[level].size() + (swap ? -1 : 1)) % gex[level].size());
    }

    for (d = 0, i = i4, j = j4; d < edge_size; ++d, --i) {
        matrix[i][j] = gex[level][cur];
        cur = ((cur + gex[level].size() + (swap ? -1 : 1)) % gex[level].size());
    }

    for (d = 0, i = i5, j = j5; d < edge_size; ++d, --i) {
        matrix[i][j] = gex[level][cur];
        cur = ((cur + gex[level].size() + (swap ? -1 : 1)) % gex[level].size());
    }

    for (d = 0, i = i6, j = j6; d < edge_size; ++d, ++j) {
        matrix[i][j] = gex[level][cur];
        cur = ((cur + gex[level].size() + (swap ? -1 : 1)) % gex[level].size());
    }
}


int main() {
    enable_fast_io;
    size_t n; std::cin >> n;
    std::vector<std::vector<size_t>> gex_matrix(2 * n - 1), gex(n);
    for (size_t i = 0; i < 2 * n - 1; ++i) {
        gex_matrix[i].resize((i < n) ? (n + i) : (3 * n - 2 - i));
        for (size_t j = 0; j < gex_matrix[i].size(); ++j) {
            std::cin >> gex_matrix[i][j];
        }
    }

    for (size_t i = 0; i < n; ++i) {
        convert_matrix_to_gex(i, gex_matrix, gex);
    }


    std::vector<size_t> start(gex.size(), 0);
    std::vector<bool> swap(gex.size(), false);
    std::string operations; std::cin >> operations;
    for (const char op : operations) {
        for (size_t i = 0; i < gex.size(); ++i) {
            if (op == 'L' || op == 'R') {
                const size_t shift = gex[i].size() + (n - i - 1) * (op == 'L' ? 1 : -1) * (swap[i] ? -1 : 1);
                start[i] = (gex[i].size() + start[i] + shift) % gex[i].size();
            }
            else {
                swap[i] = !swap[i];
                const size_t shift = (n - i - 1) * (swap[i] ? -1 : 1);
                start[i] = (gex[i].size() + start[i] + shift) % gex[i].size();
            }
        }
    }


    for (size_t i = 0; i < n; ++i) {
        convert_gex_to_matrix(i, gex, start[i], swap[i], gex_matrix);
        // std::cout << "i, start, swap = " << i << ' ' << start[i] << ' ' << swap[i] << '\n';
        // for (const auto elem : gex[i]) {
        //     std::cout << elem << ' ';
        // }
        // std::cout << '\n';
    }

    for (size_t i = 0; i < 2 * n - 1; ++i) {
        for (size_t j = 0; j < gex_matrix[i].size(); ++j) {
            std::cout << gex_matrix[i][j] << ' ';
        }
        std::cout << '\n';
    }

    return 0;
}

// 2
//  5 1
// 1 6 1
//  7 1


// 3
//     0 1 2
//   11 0 0 3
//  10 0 0 0 4
//    9 0 0 5
//     8 7 6


// 3
//     0 1 2
//   11 21 22 3
//  10 26 0 23 4
//    9 25 24 5
//     8 7 6
