#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
using ll = long long;

const int MOD = 1000000007;

ll modpow(ll a, ll e) {
    ll res = 1;
    while (e) {
        if (e & 1) res = res * a % MOD;
        a = a * a % MOD;
        e >>= 1;
    }
    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    vector<pair<int, int>> tests;
    int maxN = 0;
    for (int i = 0; i < t; i++) {
        int p, m;
        cin >> p >> m;
        tests.push_back({ p, m });
        maxN = max(maxN, 2 * p + m);
    }

    vector<ll> fact(maxN + 1, 1);
    vector<ll> inv_fact(maxN + 1, 1);

    for (int i = 1; i <= maxN; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }

    inv_fact[maxN] = modpow(fact[maxN], MOD - 2);
    for (int i = maxN; i > 0; i--) {
        inv_fact[i - 1] = inv_fact[i] * i % MOD;
    }

    auto comb = [&](int n, int k) -> ll {
        if (k < 0 || k > n) return 0;
        return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
        };

    for (const auto& test : tests) {
        int p = test.first;
        int m = test.second;
        int N = 2 * p + m;

        ll ans = 0;

        for (int k = 0; k < N; k++) {
            int s_min = max(0, k - m);
            int s_max = min(k, p);

            ll numerator = 0;


            for (int s = s_min; s <= s_max; s++) {
                ll term = comb(p, s);   
                term = term * modpow(2, s) % MOD;
                term = term * comb(m, k - s) % MOD; 
                numerator = (numerator + term) % MOD;
            }

            ll denominator = comb(N, k);
            ll Sk = numerator * modpow(denominator, MOD - 2) % MOD;
            ans = (ans + Sk) % MOD;
        }

        cout << ans << '\n';
    }

    return 0;
}