#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <map>
#include <queue>
#include <sstream>

using namespace std;

typedef vector<int> vi;
typedef vector<vi> vvi;

void mirror(vvi &tr)
{
    for (int i = 0; i < tr.size(); ++i)
    {
        for (int j = 0; j < (i + 1) / 2; ++j)
        {
            swap(tr[i][j], tr[i][i - j]);
        }
    }
}

void rotate(vi &vec, int rotated)
{
    int n = vec.size();
    rotated = rotated % n;
    if (rotated == 0)
        return;

    reverse(vec.begin(), vec.end() - rotated);
    reverse(vec.end() - rotated, vec.end());
    reverse(vec.begin(), vec.end());
}

int mod(int a, int b)
{
    int result = a % b;
    if (result < 0)
    {
        result += b;
    }
    return result;
}

int main()
{
    int n;
    cin >> n;
    cin.ignore();

    vvi hexagon(2 * n - 1);

    for (int i = 0; i < 2 * n - 1; i++)
    {
        string line;
        getline(cin, line);
        stringstream ss(line);
        int num;

        while (ss >> num)
        {
            hexagon[i].push_back(num);
        }
    }

    vector<vvi> sectors(6);

    // 0
    int row = n - 1;
    int col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            sectors[0].push_back(vi());
            for (int j = 0; j < i; j++)
            {
                sectors[0][i - 1].push_back(hexagon[row][col]);
                col++;
            }
        }
        row--;
        col = row;
    }

    // 1
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            sectors[1].push_back(vi());
            for (int j = 0; j < i; j++)
            {
                sectors[1][i - 1].push_back(hexagon[row][col]);
                row++;
                col++;
            }
        }
        row = n - i - 2;
        col = n - 1;
    }

    // 2
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            sectors[2].push_back(vi());
            for (int j = 0; j < i; j++)
            {
                sectors[2][i - 1].push_back(hexagon[row][col]);
                row++;
                col--;
            }
        }
        row = n - 1;
        col = n + i;
    }

    // 3
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            sectors[3].push_back(vi());
            for (int j = 0; j < i; j++)
            {
                sectors[3][i - 1].push_back(hexagon[row][col]);
                col--;
            }
        }
        row++;
        col = n - 1;
    }

    // 4
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            sectors[4].push_back(vi());
            for (int j = 0; j < i; j++)
            {
                sectors[4][i - 1].push_back(hexagon[row][col]);
                row--;
            }
        }
        row = n + i;
        col = n - i - 2;
    }

    // 5
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            sectors[5].push_back(vi());
            for (int j = 0; j < i; j++)
            {
                sectors[5][i - 1].push_back(hexagon[row][col]);
                row--;
            }
        }
        row = n - 1;
        col = n - i - 2;
    }

    vvi restored_hexagon(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++)
    {
        int size = (i < n) ? (n + i) : (3 * n - 2 - i);
        restored_hexagon[i] = vi(size, 0);
    }

    // rotation
    string s;
    cin >> s;

    vi curr(6);
    for (int i = 0; i < 6; ++i)
    {
        curr[i] = i;
    }

    int rotated = 0;
    int t = 0;
    for (char c : s)
    {
        if (c == 'L')
        {
            rotated--;
        }
        if (c == 'R')
        {
            rotated++;
        }
        if (c == 'T')
        {
            rotate(curr, mod(rotated, 6));
            swap(curr[1], curr[5]);
            swap(curr[2], curr[4]);
            t = 1 - t;
            rotated = 0;
        }
    }

    rotate(curr, mod(rotated, 6));

    if (t == 1)
    {
        for (vvi &sector : sectors)
        {
            mirror(sector);
        }
    }

    // from 0
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            for (int j = 0; j < i; j++)
            {
                restored_hexagon[row][col + t] = sectors[curr[0]][i - 1][j];
                col++;
            }
        }
        row--;
        col = row;
    }

    // from 1
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            for (int j = 0; j < i; j++)
            {
                restored_hexagon[row + t][col + t] = sectors[curr[1]][i - 1][j];
                row++;
                col++;
            }
        }
        row = n - i - 2;
        col = n - 1;
    }

    // from 2
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            for (int j = 0; j < i; j++)
            {
                restored_hexagon[row + t][col - t] = sectors[curr[2]][i - 1][j];
                row++;
                col--;
            }
        }
        row = n - 1;
        col = n + i;
    }

    // from 3
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {

        if (i != 0)
        {
            for (int j = 0; j < i; j++)
            {
                restored_hexagon[row][col - t] = sectors[curr[3]][i - 1][j];
                col--;
            }
        }
        row++;
        col = n - 1;
    }

    // from 4
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {
        if (i != 0)
        {
            for (int j = 0; j < i; j++)
            {
                restored_hexagon[row - t][col] = sectors[curr[4]][i - 1][j];
                row--;
            }
        }
        row = n + i;
        col = n - i - 2;
    }

    // from 5
    row = n - 1;
    col = n - 1;
    for (int i = 0; i < n; i++)
    {

        if (i != 0)
        {
            for (int j = 0; j < i; j++)
            {
                restored_hexagon[row - t][col] = sectors[curr[5]][i - 1][j];
                row--;
            }
        }
        row = n - 1;
        col = n - i - 2;
    }

    restored_hexagon[n - 1][n - 1] = hexagon[n - 1][n - 1];

    for (int i = 0; i < 2 * n - 1; i++)
    {
        for (int j = 0; j < restored_hexagon[i].size(); j++)
        {
            cout << restored_hexagon[i][j] << " ";
        }
        cout << endl;
    }

    return 0;
}