#include <bits/stdc++.h>
using namespace std;
#define int long long

vector<int> dp;
vector<int> dppref;

int len(int n) {
  int l = 0;
  while(n > 0)
  {
    l++;
    n/=10;
  }
  return l;
}

int collatz(int n) {
  if(n%2){
    return 3*n+1;
  }
  else {
    return n / 2;
  }
}

pair<int, int> calcrand(int n, int steps) {
  int bestCost = (long long)1e18;
  int bestCostI = -1;
  int initcost = 0;
  for(int i = 0; i < steps; i++) {
    initcost += len(collatz(n));
    n = collatz(n);
    int l = 3*n+1;
    int r = min((long long) dp.size(), 6*n+1);
    int cost = initcost + (dppref[r] - dppref[l]) / (r-l);
    if(cost < bestCost) {
      bestCost = cost; 
      bestCostI = i;
    }
  }
  return {bestCostI, bestCost};
}

int collatzdp(vector<int>& dp, int n) {
  if(n < dp.size() && dp[n] != -1)
    return dp[n];

  if(n % 2 == 0) {
    if(n < dp.size())
      dp[n] = len(n/2) + collatzdp(dp, n/2); 
    else
      return len(n/2) + collatzdp(dp, n/2);
  }
  else {
    if(n < dp.size())
      dp[n] = len(3*n + 1) + collatzdp(dp, 3*n+1);
    else
      return len(3*n + 1) + collatzdp(dp, 3*n+1);
  }
  return dp[n];
}

void solve() {
  int x;
  cin >> x;

  while(x != 1) {
    auto [steps, randCost] = calcrand(x, 10);
    int randomBetter = -1;
    if(collatzdp(dp, x) > randCost) {
      randomBetter = steps;
    }
    if(randomBetter != -1) {
      for(int i = 0; i < randomBetter; i++) {
        cout << "collatz\n";
        cout.flush();
        cin >> x;
      }
      cout << "random\n";
      cout.flush();
      cin >> x;
      continue;
    }
    cout << "collatz\n";
    cout.flush();
    cin >> x;
  }
}



int32_t main() {
  int t;
  cin >> t;
  
  dp = vector<int>((int) 2e7, -1);
  dp[0] = 0;
  dp[1] = 0;
  for(int i = 0; i < 1e7; i++) {
    if(dp[i] == -1)
      collatzdp(dp, i);
  }
  dppref = vector<int>(dp.size()+1);
  for(int i = 1; i < dppref.size(); i++) {
    dppref[i] = dp[i-1] + dppref[i-1];
  }

  while(t--) {
    solve();
  }
}