#include <bits/stdc++.h>

using namespace std;

#define int long long
#define endl '\n'

typedef long long ll;

const int INF = 1e18;

void Fast() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

#define Vec Point

struct Point {
    int x, y;

    Point(int _x, int _y) : x(_x), y(_y) {};

    Point() {}

    Point operator+(const Point &a) const {
        Point c;
        c.x = x + a.x;
        c.y = y + a.y;
        return c;
    }

    Point operator-(const Point &a) const {
        Point c;
        c.x = x - a.x;
        c.y = y - a.y;
        return c;
    }

    int operator*(const Vec &a) const {
        return x * a.x + y * a.y;
    }

    int operator^(const Vec &a) const {
        return x * a.y - y * a.x;
    }
};

istream &operator>>(istream &in, Point &p) {
    in >> p.x >> p.y;
    return in;
}

int dist(Point a, Point b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

int ind;

bool cmp(const Point &a, const Point &b) {
    return (a ^ b) > 0 || (a ^ b) == 0 && dist(a, {0, 0}) < dist(b, {0, 0});
}

vector<Point> convex_hull(vector<Point> &pol) {
    int n = pol.size();
    ind = 0;
    for (int i = 1; i < n; i++) {
        if (pol[ind].x > pol[i].x || pol[ind].x == pol[i].x && pol[ind].y > pol[i].y) ind = i;
    }
    Point o = pol[ind];
    for (int i = 0; i < n; i++) {
        pol[i] = pol[i] - o;
    }
    sort(pol.begin(), pol.end(), cmp);
    vector<Point> ch;
    for (int i = 0; i < n; i++) {
        while (ch.size() >= 2 && (((ch[ch.size() - 1] - ch[ch.size() - 2]) ^ (pol[i] - ch[ch.size() - 1])) <= 0))
            ch.pop_back();
        ch.push_back(pol[i]);
    }
    for (auto &i: ch) i = i + o;
    return ch;
}

signed main() {
    Fast();
    int n;
    cin >> n;
    vector<Point> pol(n);
    for (int i = 0; i < n; i++) {
        cin >> pol[i];
    }
    int a1 = 0, a2 = 1;
    int ans = -INF;
    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            if (i == j) {
                continue;
            }
            int d = dist(pol[i], pol[j]);
            if (ans < d) {
                ans = d;
                a1 = i, a2 = j;
            }
        }
    }
    Vec v = pol[a1] - pol[a2];
    int a = v.x, b = v.y;
    int c = -a * pol[a1].x - b * pol[a1].y;
    cout << a << " " << b << " " << c << endl;
    a = v.x, b = v.y;
    c = -a * pol[a2].x - b * pol[a2].y;
    cout << a << " " << b << " " << c << endl;
    return 0;
}