#include<bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;

struct point
{
    ll x;
    ll y;

    point()
    {
        x = 0;
        y = 0;
    }

    point(ll a, ll b)
    {
        x = a;
        y = b;
    }

    point operator+(point o)
    {
        return point(x + o.x, y + o.y);
    }
    point operator-(point o)
    {
        return point(x - o.x, y - o.y);
    }
    point operator*(ll k)
    {
        return point(x * k, y * k);
    }
    ld operator*(point o)
    {
        return x * o.x + y * o.y;
    }
    ld operator%(point o)
    {
        return x * o.y - o.x * y;
    }
    ll abs2()
    {
        return (*this) * (*this);
    }
};

typedef point pt;

bool cmp (pt a, pt b) {
	return a.x < b.x || a.x == b.x && a.y < b.y;
}

bool cw (pt a, pt b, pt c) {
	return a.x*(b.y-c.y)+b.x*(c.y-a.y)+c.x*(a.y-b.y) < 0;
}

bool ccw (pt a, pt b, pt c) {
	return a.x*(b.y-c.y)+b.x*(c.y-a.y)+c.x*(a.y-b.y) > 0;
}

void convex_hull (vector<pt> & a) {
	if (a.size() == 1)  return;
	sort (a.begin(), a.end(), &cmp);
	pt p1 = a[0],  p2 = a.back();
	vector<pt> up, down;
	up.push_back (p1);
	down.push_back (p1);
	for (size_t i=1; i<a.size(); ++i) {
		if (i==a.size()-1 || cw (p1, a[i], p2)) {
			while (up.size()>=2 && !cw (up[up.size()-2], up[up.size()-1], a[i]))
				up.pop_back();
			up.push_back (a[i]);
		}
		if (i==a.size()-1 || ccw (p1, a[i], p2)) {
			while (down.size()>=2 && !ccw (down[down.size()-2], down[down.size()-1], a[i]))
				down.pop_back();
			down.push_back (a[i]);
		}
	}
	a.clear();
	for (size_t i=0; i<up.size(); ++i)
		a.push_back (up[i]);
	for (size_t i=down.size()-2; i>0; --i)
		a.push_back (down[i]);
}

istream& operator>> (istream& is, point& p)
{
    is >> p.x >> p.y;
    return is;
}
ostream& operator<< (ostream& os, point& p)
{
    os << p.x << " " <<  p.y;
    return os;
}

void fun(point x, point y)
{
    ll a = y.y - x.y;
    ll b = x.x - y.x;
    ll c = -a*x.x - b*x.y;
    cout << a << ' ' << b << ' ' << c << '\n';
}

int main()
{
    int n;

    cin >> n;
    vector<point> v(n);
    for(int i = 0; i < n; ++i)
    {
        cin >> v[i];
    }

    ll mix = 0;
    int i1, i2;

    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            ll d = (v[i] - v[j]).abs2();
            if (d > mix) {
                mix = d;
                i1 = i; i2 = j;
            }
        }
    }

    point napr  = v[i1] - v[i2];
    swap(napr.x, napr.y);
    napr.x *= -1;
    fun(v[i1], v[i1] + napr);
    fun(v[i2],  v[i2] + napr);

}