#pragma gcc optimize("Ofast")

#include <iostream>
#include <algorithm>
#include <vector>
#include <iomanip>
#include <map>
#include <set>
#include <fstream>
#include <string>
#include <bitset>
#include <ctime>
#include <random>
#include <iterator>
#include <cmath>
#include <queue>
#include <deque>
#include <time.h>
 
using namespace std;
 
#define all(a) a.begin(), a.end()
#define rsort(a) sort(a, [&](auto b, auto c) {return b > c;})
 
ifstream fin("input.txt");
ofstream fout("output.txt");
 
using ll = long long;
using ld = long double;
using ull = unsigned long long;
 
ll const inf = 1e18;
 
template <class T>
istream& operator>> (istream& in, vector<T>& a)
{
	for (T& e : a)
		in >> e;
	return in;
}
 
template <class T>
ostream& operator<< (ostream& out, const vector<T>& a)
{
	for (const T& e : a)
		out << e << " ";
	return out;
}
 
template<class T, class N> auto min(T a, N b)
{
	return sizeof(a) > sizeof(b) ? min(a, (T)b) : min((N)a, b);
}
 
template<class T, class N> auto max(T a, N b)
{
	return sizeof(a) > sizeof(b) ? max(a, (T)b) : max((N)a, b);
}
 
const ll MOD = 998244353;

ll true_mod(ll a, ll m) {
	if (m < 0) {
		m *= -1;
	}
	return ((a % m) + m) % m;
}

ll true_div(ll a, ll m) {
	return (a - true_mod(a , m)) / m;
}
 
ll bin_pow_mod(ll a, ll n)
{
	ll res = 1;
	while (n)
	{
		if (n & 1)
		{
			res *= a;
			res %= MOD;
		}
 
		n >>= 1;
		a *= a;
		a %= MOD;
	}
 
	return res;
}
 
ll bin_pow(ll a, ll n)
{
	ll res = 1;
	while (n)
	{
		if (n & 1)
		{
			res *= a;
		}
 
		n >>= 1;
		a *= a;
	}
 
	return res;
}
 
ll gcd(ll a, ll b)
{
	while (b)
	{
		a %= b;
		swap(a, b);
	}
	return a;
}
 
random_device rd;
mt19937 mersenne(rd());

void solve();
 
// #define TIME
#define ONCE
 
signed main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	cout.tie(0);
 
	ll TT = 1;
#ifndef ONCE 
	cin >> TT;
#endif
	while (TT--)
	{
#ifdef TIME
		clock_t start, end;
 
		start = clock();
#endif
		solve();
#ifdef TIME
		end = clock();
 
		cerr << "\ntime: " << ((double)end - start) / ((double)CLOCKS_PER_SEC) << " s\n";
#endif
		cerr << '\n';
	}
	return 0;
}

ll reverse(ll n)
{
	vector<ll> bits;
	while (n)
	{
		bits.push_back(n % 2);
		n /= 2;
	}
	ll k = 0;
	for (auto bit : bits)
	{
		k *= 2;
		k += bit;
	}
	return k;
}


void solve() 
{
	ll pos = 0;
	bool rev = false;

	ll n; cin >> n;

	map<ll,map<ll,map<ll,ll>>> hex;

	for (int i = 0; i < 2 * n - 1; ++i)
	{
		ll len = 0;

		ll x = i + 1 - n;
		ll y = n - 1;
		ll z = -x - y;
		if (i < n)
		{
			len = n + i;
		}
		else
		{
			z = - n + 1;
			y = -x -z;
			len = n + (2 * n - 2 - i);
		}

		while (len--) 
		{
			ll d = max({abs(x),abs(y),abs(z)});

			ll sector = -1;
			ll idx = -1;
			if (z == d && y != -d)
			{
				sector = 0;
				idx = -y;
			}
			if (y == -d && x != d)
			{
				sector = 1;
				idx = x;
			}
			if (x == d && z != -d)
			{
				sector = 2;
				idx = -z;
			}
			if (z == -d && y != d)
			{
				sector = 3;
				idx = y;
			}
			if (y == d && x != -d)
			{
				sector = 4;
				idx = -x;
			}
			if (x == -d && z != d)
			{
				sector = 5;
				idx = z;
			}

			cin >> hex[d][sector][idx];

			y--;
			z++;
		}
	}



	string coms; cin >> coms;

	for (auto com : coms)
	{
		if (com == 'L')
		{
			pos = (pos + 5) % 6;
		}
		if (com == 'R')
		{
			pos = (pos + 1) % 6;
		}
		if (com == 'T')
		{
			pos = 5 - pos;
			rev = !rev;
		}
	}

	// output

	for (int i = 0; i < 2 * n - 1; ++i)
	{
		ll len = 0;

		ll x = i + 1 - n;
		ll y = n - 1;
		ll z = -x - y;
		if (i < n)
		{
			len = n + i;
		}
		else
		{
			z = - n + 1;
			y = -x -z;
			len = n + (2 * n - 2 - i);
		}

		while (len--) 
		{
			ll d = max({abs(x),abs(y),abs(z)});

			ll sector = -1;
			ll idx = -1;
			if (z == d && y != -d)
			{
				sector = 0;
				idx = -y;
			}
			if (y == -d && x != d)
			{
				sector = 1;
				idx = x;
			}
			if (x == d && z != -d)
			{
				sector = 2;
				idx = -z;
			}
			if (z == -d && y != d)
			{
				sector = 3;
				idx = y;
			}
			if (y == d && x != -d)
			{
				sector = 4;
				idx = -x;
			}
			if (x == -d && z != d)
			{
				sector = 5;
				idx = z;
			}

			ll nsector = ((sector - pos) % 6 + 6) % 6;
			if (d == 0)
			{
				cout << hex[0][-1][-1];
			} else
			if (!rev)
			{
				cout << hex[d][nsector][idx];
			}
			else
			{
				if (idx == 0)
				{
					cout << hex[d][(6-nsector) % 6][0];
				}
				else
				{
					cout << hex[d][(5-nsector) % 6][d - idx];
				}
			}

			cout << " ";

			y--;
			z++;
		}
		cout << '\n';
	}


}
