#include <bits/stdc++.h>
using namespace std;

#define endl '\n'

void print_spaces(int n) {
    for (int i = 0; i < n; i++) {
        cout << " ";
    }
}

void print_gecs(vector<vector<int>>& arr, vector<int>& sizes, int n) {
    for (int i = 0; i < 2 * n - 1; i++) {
        print_spaces(2 * n - sizes[i] - 1);
        for (int j = 0; j < sizes[i]; j++) {
            cout << arr[i][j] << " ";
        }
        cout << endl;
    }
}

vector<vector<int>> turn_clockwise(vector<vector<int>>& arr, vector<int>& sizes,
                                   int n) {
    vector<vector<int>> answ(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++) {
        answ[i].resize(sizes[i]);
    }
    for (int i = 0; i < 2 * n - 1; i++) {
        int row = 0;
        int col = 0;
        if (i < n) {
            row = 0;
            col = n - i - 1;
        } else {
            row = i - n + 1;
            col = 0;
        }
        for (int j = 0; j < sizes[i]; j++) {
            answ[row][col] = arr[i][j];
            row++;
            if (row < n) {
                col++;
            }
        }
        // print_gecs(answ, sizes, n);
    }
    return answ;
}

vector<vector<int>> mirror_transform(vector<vector<int>>& arr,
                                     vector<int>& sizes, int n) {
    vector<vector<int>> answ(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++) {
        answ[i].resize(sizes[i]);
    }
    for (int i = 0; i < 2 * n - 1; i++) {
        for (int j = 0; j < sizes[i]; j++) {
            answ[i][j] = arr[i][j];
        }
        for (int j = 0; j < sizes[i] / 2; j++) {
            swap(answ[i][j], answ[i][sizes[i] - 1 - j]);
        }
    }
    return answ;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int n;
    cin >> n;
    vector<vector<int>> gecs(2 * n - 1);
    vector<int> list_of_sizes(2 * n - 1);
    int len = n;
    for (int i = 0; i < 2 * n - 1; i++) {
        gecs[i].resize(len);
        list_of_sizes[i] = len;
        for (int j = 0; j < len; j++) {
            cin >> gecs[i][j];
        }
        if (i < n - 1) {
            len++;
        } else {
            len--;
        }
    }

    string s;
    cin >> s;
    bool need_to_swap = false;
    for (int i = 0; i < s.size(); i++) {
        if (s[i] == 'T') {
            need_to_swap = !need_to_swap;
        }
        if (s[i] == 'L') {
            if (need_to_swap) {
                s[i] = 'R';
            }
        } else {
            if (s[i] == 'R') {
                if (need_to_swap) {
                    s[i] = 'L';
                }
            }
        }
    }
    int L = 0;
    int R = 0;
    for (int i = 0; i < s.size(); i++) {
        if (s[i] == 'L') {
            L++;
        }
        if (s[i] == 'R') {
            R++;
        }
    }
    L %= 6;
    R %= 6;
    int clockwise = R - L;
    if (clockwise < 0) {
        clockwise += 6;
    }

    while (clockwise--) {
        gecs = turn_clockwise(gecs, list_of_sizes, n);
    }

    if (need_to_swap) {
        gecs = mirror_transform(gecs, list_of_sizes, n);
    }

    print_gecs(gecs, list_of_sizes, n);
}
