#ifdef ONPC
#define _GLIBCXX_DEBUG
#endif

#include <bits/stdc++.h>

using namespace std;

#define int long long
#define ld long double
#define fi first
#define sec second
#define pii pair<int, int>
#define pll pair<long long, long long>
#define pld pair<long double, long double>
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define sz(a) (int)a.size()
// #define endl "\n"

#ifdef ONPC
#include "algo/debug.h"
#else
#define debug(...) 42
#endif

const int MOD = 1e9 + 7;
const int LLINF = 2e18 + 7;
const int INF = 2e9 + 7;
const int N = 2e5 + 13;
const ld eps = 0.00000001;


struct P {
  int x, y;

  P(int _x, int _y) {
    x = _x; y = _y;
  }

  P() = default;
  P(const P &p) = default;


  void read() {
    cin >> x >> y;
  }

  // P (int x, int y) {
  //   this->x = x;
  //   this->y = y;
  // }

  P operator - (const P& b) const {
    return P{ x - b.x, y - b.y };
  }

  P operator + (const P& b) const {
    return P{ x + b.x, y + b.y };
  }

  void operator -= (const P& b) {
    x -= b.x;
    y -= b.y;
  }

  void operator += (const P& b) {
    x += b.x;
    y += b.y;
  }

  int operator * (const P& b) const {
    return x * b.y - b.x * y;
  }

  bool operator<(const P& b) const {
    if (x == b.x) {
      return y < b.y;
    }
    return x < b.x;
  }

  bool operator>(const P& b) const {
    if (x == b.x) {
      return y > b.y;
    }
    return x > b.x;
  }

  int area(const P& b, const P& c) const {
    return (b - *this) * (c - *this);
  }

  ld length() {
    return sqrt(x * x + y * y);
  }
};

vector<P> get_convex_hull(vector<P> p) {

  sort(all(p));

  vector <P> hull;

  for (int i = 0; i < 2; i++) {
    int S = sz(hull);
    for (P c : p) {
      while (sz(hull) >= S + 2) {
        P a = hull.end()[-2];
        P b = hull.end()[-1];
        if ((c - b) * (a - b) >= 0) {
          break;
        }
        hull.pop_back();
      }
      hull.push_back(c);
    }

    hull.pop_back();
    reverse(all(p));
  }

  return hull;
}

int det(P a, P b) {
  return a.x * b.y - a.y * b.x;
}

int dot(P a, P b) {
  return a.x * b.x + a.y * b.y;
}

P neg(P p) {
  return P(-p.x, -p.y);
}

ld dist(P a, P b) {
  return sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

/*

4
0 0
3 4
8 1
1 1

*/

void solve() {
  int n;
  cin >> n;
  vector <P> p(n);
  for (int i = 0; i < n; i++) {
    p[i].read();
  }

  auto hull = get_convex_hull(p);

  //
  // for (int i = 0; i < sz(hull); ++i) {
  //   cout << hull[i].x << ' ' << hull[i].y << endl;
  // }
  // cout << endl;
  //

  ld best = 0;
  int a, b, c1, c2;
  for (int i = 0; i < sz(hull); ++i) {
    for (int j = i + 1; j < sz(hull); ++j) {
      P x = hull[i], x_s = hull[(i + 1) % sz(hull)];
      P y = hull[j], y_s = hull[j - 1];
      P l1 = x_s - x;
      P l2 = y_s - y;
      P L = y - x;

      ld alpha = atan2(det(neg(l1), L), dot(neg(l1), L));
      ld beta = atan2(det(neg(l2), neg(L)), dot(neg(l2), neg(L)));

      if (alpha + beta >= M_PI) {
        ld d = dist(x, y);
        if (d > best) {
          best = d;
          a = L.x;
          b = L.y;
          c1 = -(a * x.x + b * x.y);
          c2 = -(a * y.x + b * y.y);

          debug(d);
          debug(x.x, x.y);
          debug(y.x, y.y);
          debug(a, b, c1);
          debug(a, b, c2);
          debug();
        }
      }
    }
  }

  cout << a << ' ' << b << ' ' << c1 << endl;
  cout << a << ' ' << b << ' ' << c2 << endl;
}

int32_t main() {
  ios_base::sync_with_stdio(0);
  cin.tie(0);
  cout.precision(15);
#ifdef ONPC
  cout << "\n";
#endif

  int t = 1;
  // cin >> t;
  while (t--) {
    solve();
#ifdef ONPC
    cout << "________________________\n";
#endif
  }

  return 0;
}
