def solve():
    """
    Правильное решение задачи "Кто я?" с использованием XOR
    """
    # Читаем индикатор запуска
    launch = int(input())
    
    if launch == 0:
        # Первый запуск: определяем, какой игрок должен угадать
        n = int(input())  # общее количество игроков
        cards = list(map(int, input().split()))
        
        # Используем XOR всех карт для выбора игрока
        xor_sum = 0
        for card in cards:
            xor_sum ^= card
        
        player_to_guess = xor_sum % n + 1
        print(player_to_guess)
        
    else:
        # Второй запуск: выбранный игрок делает предположение
        player_number = launch
        n = int(input())  # количество видимых карт
        visible_cards = list(map(int, input().split()))
        
        # Вычисляем XOR видимых карт
        visible_xor = 0
        for card in visible_cards:
            visible_xor ^= card
        
        total_players = n + 1  # общее количество игроков
        
        # Правильная логика декодирования:
        # Мы знаем, что total_xor % total_players + 1 = player_number
        # Где total_xor = visible_xor ^ missing_card
        # Значит: (visible_xor ^ missing_card) % total_players + 1 = player_number
        # (visible_xor ^ missing_card) % total_players = player_number - 1
        
        # Находим missing_card такой, что (visible_xor ^ missing_card) % total_players = player_number - 1
        target = (player_number - 1) % total_players
        
        # Перебираем возможные значения missing_card от 1 до total_players
        for missing_card in range(1, total_players + 1):
            if (visible_xor ^ missing_card) % total_players == target:
                print(missing_card)
                return
        
        # Если не нашли, попробуем 0 (хотя по условию карты от 1 до n)
        if (visible_xor ^ 0) % total_players == target:
            print(0)
            return

if __name__ == "__main__":
    solve()
