#include <iostream>
#include <sstream>
#include <vector>
#include <array>
#include <algorithm>
#include <string>

using namespace std;

int main() {
    ios::sync_with_stdio(false);

    int n;
    if (!(cin >> n))
        return 0;
    string tmp;
    getline(cin, tmp);

    int rows = 2 * n - 1;
    vector<vector<int>> old_hex(rows);
    string line;
    for (int i = 0; i < rows; ++i) {
        getline(cin, line);
        stringstream ss(line);
        int v;
        while (ss >> v) old_hex[i].push_back(v);
    }
    string ops;
    if (!getline(cin, ops)) ops = "";
    auto first_non = ops.find_first_not_of(" \t\r\n");
    if (first_non == string::npos) ops = "";
    else ops = ops.substr(first_non, ops.find_last_not_of(" \t\r\n") - first_non + 1);

    vector<int> len(rows);
    for (int i = 0; i < rows; ++i) {
        if (i < n) len[i] = n + i;
        else len[i] = 3 * n - 2 - i;
    }

    vector<int> offset(rows);
    for (int i = 0; i < rows; ++i) offset[i] = min(i, n - 1);

    array<array<int, 3>, 3> M;
    for (int r = 0; r < 3; ++r) for (int c = 0; c < 3; ++c) M[r][c] = (r == c) ? 1 : 0;

    array<array<int, 3>, 3> MR = { array<int,3>{0,0,-1}, array<int,3>{-1,0,0}, array<int,3>{0,-1,0} };
    array<array<int, 3>, 3> ML = { array<int,3>{0,-1,0}, array<int,3>{0,0,-1}, array<int,3>{-1,0,0} };
    array<array<int, 3>, 3> MT = { array<int,3>{1,0,0}, array<int,3>{0,0,1}, array<int,3>{0,1,0} };

    auto mul = [&](const array<array<int, 3>, 3>& A, const array<array<int, 3>, 3>& B) {
        array<array<int, 3>, 3> C;
        for (int i = 0; i < 3; ++i)
            for (int j = 0; j < 3; ++j) {
                int s = 0;
                for (int k = 0; k < 3; ++k) s += A[i][k] * B[k][j];
                C[i][j] = s;
            }
        return C;
        };

    for (char ch : ops) {
        if (ch == 'R') {
            M = mul(MR, M);
        }
        else if (ch == 'L') {
            M = mul(ML, M);
        }
        else if (ch == 'T') {
            M = mul(MT, M);
        }
        else {
        }
    }

    vector<vector<int>> new_hex(rows);
    for (int i = 0; i < rows; ++i) new_hex[i].assign(len[i], 0);

    for (int i0 = 0; i0 < rows; ++i0) {
        for (int j0 = 0; j0 < (int)old_hex[i0].size(); ++j0) {
            int x0 = i0 - (n - 1);
            int y0 = j0 - offset[i0];
            int z0 = -x0 - y0;

            int nx = M[0][0] * x0 + M[0][1] * y0 + M[0][2] * z0;
            int ny = M[1][0] * x0 + M[1][1] * y0 + M[1][2] * z0;
            int nz = M[2][0] * x0 + M[2][1] * y0 + M[2][2] * z0;
            int i_new = nx + (n - 1);
            if (i_new < 0 || i_new >= rows) {
                continue;
            }
            int j_new = ny + offset[i_new];
            if (j_new < 0 || j_new >= len[i_new]) {
                continue;
            }
            new_hex[i_new][j_new] = old_hex[i0][j0];
        }
    }

    for (int i = 0; i < rows; ++i) {
        for (int j = 0; j < (int)new_hex[i].size(); ++j) {
            if (j) cout << ' ';
            cout << new_hex[i][j];
        }
        cout << '\n';
    }

    return 0;
}
