#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
using namespace std;



vector<vector<int>> rightRotate(vector<vector<int>>& gex, int n, int totalR) {
    int N = n - 1;
    int rows = gex.size();

    map<tuple<int, int, int>, int> cube;

    for( int i = 0; i < rows; i++){
        int z =  i - N;
        int xmin = max(-N, -z -N);

        for(int j = 0; j < gex[i].size(); j++)
        {
            int x = xmin + j;
            int y = - x - z;
            cube[make_tuple(x, y, z)] = gex[i][j];
        }
    }

    map<tuple<int, int, int>, int> rCube;
    for(const auto& line: cube){
        auto [x, y, z] = line.first;

        int num = line.second;

        for(int i = 0; i < totalR; i++)
        {
            int nx = -z;
            int ny = -x;
            int nz = -y;
            x = nx;
            y = ny;
            z = nz;
        }
        rCube[make_tuple(x, y, z)] = num;
    }

    vector<vector<int>> res(rows);
    for(int i = 0; i < rows; i++){
        int z = i - N;
        int x_min = max(-N, -z - N);
        int x_max = min(N, -z + N);
        for(int x = x_min; x <= x_max; x++){
            int y = -x - z;
            res[i].push_back(rCube[make_tuple(x, y, z)]);
        }
    }
    return res;
}

void simmOtr(vector<vector<int>>& gex){
    for(int i = 0; i < gex.size(); i++){
        reverse(gex[i].begin(), gex[i].end());
    }
};

int main() {
    int n;
    
    cin >> n;
    vector<vector<int>> gex(2 * n-1);
    int num;
    int row;
    int k=0;
    int size = n;

    for (int i = 0; i < 2 * n - 1; ++i) {
        int rowSize = (i < n) ? (n + i) : (3 * n - 2 - i);
        gex[i].resize(rowSize);
        for (int j = 0; j < rowSize; ++j) {
            std::cin >> gex[i][j];
        }
    }

    int totalR = 0;
    bool isT = false;

    char op;
    while(cin >> op)
    {
        if(op == 'L'){
            if(!isT)
                totalR = (totalR + 5) % 6;
            else totalR = (totalR + 1) % 6; 
        } else if(op == 'R'){
            if(!isT)
                totalR = (totalR + 1) % 6;
            else 
                totalR = (totalR + 5) % 6;
        } else if(op == 'T'){
            isT = !isT;
        }
    } 

    vector<vector<int>> result = rightRotate(gex, n, totalR);

    if(isT){
        simmOtr(result);
    }

    for(int i = 0; i < result.size(); i++)
    {
        for(int j = 0; j < result[i].size(); j++)
            cout << result[i][j] << " ";
        cout << "\n";
    }
}