#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;
using ll = long long;
const int MOD = 1e9+7;

ll mod_pow(ll a, ll b){
    ll r=1%MOD;
    a%=MOD;
    while(b){
        if(b&1) r = r*a%MOD;
        a = a*a%MOD;
        b >>= 1;
    }
    return r;
}

void precompute(int N, vector<ll>& fact, vector<ll>& inv_fact, vector<ll>& inv){
    fact.assign(N+1,0);
    inv_fact.assign(N+1,0);
    inv.assign(N+1,0);
    fact[0]=1;
    for(int i=1;i<=N;i++) fact[i]=fact[i-1]*i%MOD;
    inv_fact[N]=mod_pow(fact[N], MOD-2);
    for(int i=N-1;i>=0;i--) inv_fact[i]=inv_fact[i+1]*(i+1)%MOD;
    if (N>=1) inv[1]=1;
    for(int i=2;i<=N;i++) inv[i] = (MOD - (MOD / i)) * inv[MOD % i] % MOD;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    if(!(cin>>t)) return 0;
    vector<pair<int,int>> tests(t);
    int maxN = 0;
    for(int i=0;i<t;i++){
        int p,m; cin>>p>>m;
        tests[i] = {p,m};
        int n = 2*p + m;
        if(n > maxN) maxN = n;
    }
    vector<ll> fact, inv_fact, inv;
    if(maxN > 0) precompute(maxN, fact, inv_fact, inv);

    for(auto &ts : tests){
        int p = ts.first, m = ts.second;
        int n = 2*p + m;
        int K = p + m;

        ll ap = 1;
        ll ac = ( (2LL * p + m) % MOD + MOD ) % MOD;
        ll P = 0;
        P = (P + fact[0] * fact[n] % MOD * ap) % MOD;
        if(K >= 1){
            P = (P + fact[1] * fact[n-1] % MOD * ac) % MOD;
        }
        if(K >= 2){
            for(int i=1; i<=K-1; ++i){
                ll term1 = ( ( (2LL * p + m) % MOD - (3LL * i) % MOD ) % MOD + MOD ) % MOD;
                term1 = term1 * ac % MOD;
                ll term2 = ( ( (2LL * p + 2LL * m - 2LL * i + 2LL) % MOD ) + MOD ) % MOD;
                term2 = term2 * ap % MOD;
                ll an = (term1 + term2) % MOD;
                an = an * inv[i+1] % MOD;
                int k = i+1;
                P = (P + fact[k] * fact[n - k] % MOD * an) % MOD;
                ap = ac;
                ac = an;
            }
        }

        ll E = P * inv_fact[n] % MOD;
        cout << E << '\n';
    }
    return 0;
}
