from random import randint
import sys

sys.set_int_max_str_digits(10 ** 6)

def collatz(x):
    assert x != 1
    if x % 2 == 0:
        return x // 2
    return 3 * x + 1

def collatz_k(x, k):
    for i in range(k):
        if x == 1:
            break
        x = collatz(x)
    return x

def collatz_min(x, k):
    a = [x]
    for i in range(k):
        assert x != 1
        x = collatz(x)
        a.append(x)
    return a.index(min(a))

def rnd_s(x):
    print('random')
    sys.stdout.flush()
    y = int(input())
    if y == 0:
        exit(-1)
    return y

def rnd_t(x):
    x = randint(3 * x + 1, 6 * x)
    return x

def solve(x, rnd, pr=True):
    K = 100
    R = 20
    D = 0 
    c = 0
    while x != 1:
        if collatz_k(x, K) == 1:
            while x != 1:
                if pr:
                    print('collatz')
                    sys.stdout.flush()
                    _ = int(input())
                    if _ == 0:
                        exit(-1)
                x = collatz(x)
                c += len(str(x))
            return c
        else:
            for i in range(collatz_min(x, R)):
                x = collatz(x)
                if pr:
                    print('collatz')
                    sys.stdout.flush()
                    _ = int(input())
                    if _ == 0:
                        exit(-1)
                c += len(str(x))
            x = rnd(x)
            c += len(str(x))
            K += D
    exit(-1)

def main():
    t = int(input())
    for i in range(t):
        x = int(input())
        solve(x, rnd_s)

def test():
    t = 50
    C = 0
    for i in range(t):
        x = randint(2, 10 ** 7)
        C += solve(x, rnd_t, False)
    return C / t

main()

# N = 100
# A = [test() for i in range(N)]
# print(sum(A) / N)
# B = [A[i] < 600 for i in range(N)]
# print(B.count(True) / N)
# print(max(A))
