notes = "ABCDEFG"

# Смоделируем наше фортепиано
piano = {}
for i in range(52):
    letter = notes[i % 7]
    if letter not in piano:
        piano[letter] = []
    piano[letter].append(i)

    
# вводим все композиции
# В цикле по всем проверяем может ли она быть сыграна
for composition in [input().strip() for _ in range(int(input()))]:
    # Множество возможных позиций для первой ноты
    cur_pos = set(piano[composition[0]])
    # Проверяем все клавиши композиции
    for note in composition[1:]:
        next_pos = set()
        for pos in piano[note]:
            for prev in cur_pos:
                if (abs(pos - prev) <= 3):
                    next_pos.add(pos)
                    break
        cur_pos = next_pos
        if not cur_pos:
            break
    print("Yes" if cur_pos else "No")
