def get_gex(n):
    gex = []
    for _ in range(n * 2 - 1):
        line = input().split()
        gex.append([int(x) for x in line])
    return gex

def rotate_to_l(gex, n):
    size = len(gex)
    result = []
    n1 = n - 1
    n2 = 2 * n - 2
    
    for i in range(size):
        row_len = len(gex[i])
        new_row = []
        col_start = max(0, n1 - i)
        row_start = max(0, i - n1)
        max_col = n2 - i
        
        for j in range(row_len):
            row = row_start + j
            col = min(col_start + j, max_col)
            new_row.append(gex[row][col])
        
        result.append(new_row)
    
    return result

def print_gex(gex, n):
    for i in range(n * 2 - 1):
        spaces = abs(n - i - 1)
        if spaces > 0:
            print(" " * spaces, end="")
        print(" ".join(map(str, gex[i])))

def optimize_commands(commands):
    old_commands = ""
    while old_commands != commands:
        old_commands = commands
        commands = commands.replace("LR", "").replace("RL", "")
        commands = commands.replace("TT", "")
        commands = commands.replace("TRT", "L").replace("TLT", "R")
    return commands

def main():
    n = int(input())
    gex = get_gex(n)
    commands = input().strip()
    
    # Оптимизируем команды
    commands = optimize_commands(commands)
    
    # Разбиваем команды по 'T'
    parts = commands.split('T')
    count_reverse = len(parts) - 1
    
    # Обрабатываем каждую часть
    for i, part in enumerate(parts):
        count_L = part.count('L')
        count_R = part.count('R')
        
        # Вычисляем чистые повороты (по модулю 6)
        net_rotations = (count_R - count_L) % 6
        if net_rotations < 0:
            net_rotations += 6
        
        # Выполняем повороты влево (поворот вправо = 5 поворотов влево)
        # Если net_rotations <= 3, делаем повороты вправо через повороты влево
        if net_rotations <= 3:
            # Поворот вправо на k = поворот влево на (6-k)
            rotations_needed = (6 - net_rotations) % 6
        else:
            # Поворот влево на (6 - net_rotations)
            rotations_needed = 6 - net_rotations
        
        for _ in range(rotations_needed):
            gex = rotate_to_l(gex, n)
        
        # Выполняем отражение если нужно
        if count_reverse > 0:
            gex = [line[::-1] for line in gex]
            count_reverse -= 1
    
    print_gex(gex, n)

if __name__ == "__main__":
    main()