MOD = 10**9 + 7

def precompute_factorials(nmax, MOD=MOD):
    fact = [1] * (nmax + 1)
    invfact = [1] * (nmax + 1)
    for i in range(1, nmax + 1):
        fact[i] = fact[i-1] * i % MOD
    invfact[nmax] = pow(fact[nmax], MOD-2, MOD)
    for i in range(nmax, 0, -1):
        invfact[i-1] = invfact[i] * i % MOD
    return fact, invfact

def C(n, k, fact, invfact):
    if k < 0 or k > n: return 0
    return fact[n] * invfact[k] % MOD * invfact[n-k] % MOD

def solve_one(p, m, fact, invfact):
    N = 2*p + m
    pow2 = [1] * (p + 1)
    for i in range(1, p+1):
        pow2[i] = (pow2[i-1] * 2) % MOD

    A = [0] * (N + 1)
    for t in range(0, p+1):
        coef_t = C(p, t, fact, invfact) * pow2[t] % MOD
        if coef_t == 0: 
            continue
        for s in range(0, m+1):
            k = t + s
            if k > N: break
            comb_ms = C(m, s, fact, invfact)
            A[k] = (A[k] + coef_t * comb_ms) % MOD

    total = 0
    for k in range(0, N):
        denom = C(N, k, fact, invfact)
        if denom == 0:
            continue
        numer = A[k]
        total = (total + numer * pow(denom, MOD-2, MOD)) % MOD
    return total

import sys
data = sys.stdin.read().strip().split()
t = int(data[0])
pairs = []
idx = 1
maxN = 0
for _ in range(t):
    p = int(data[idx]); m = int(data[idx+1]); idx += 2
    pairs.append((p,m))
    maxN = max(maxN, 2*p + m)

fact, invfact = precompute_factorials(maxN, MOD)

out_lines = []
for p, m in pairs:
    out_lines.append(str(solve_one(p, m, fact, invfact)))
print("\n".join(out_lines))
