import math


def cross(o, a, b):
    return (a[0] - o[0]) * (b[1] - o[1]) - (a[1] - o[1]) * (b[0] - o[0])


def convex_hull(points):
    if len(points) <= 1:
        return points

    points = sorted(points, key=lambda p: (p[0], p[1]))

    lower = []
    for p in points:
        while len(lower) >= 2 and cross(lower[-2], lower[-1], p) <= 0:
            lower.pop()
        lower.append(p)

    upper = []
    for p in reversed(points):
        while len(upper) >= 2 and cross(upper[-2], upper[-1], p) <= 0:
            upper.pop()
        upper.append(p)

    return lower[:-1] + upper[:-1]


def rotating_calipers(hull):
    n = len(hull)
    if n == 1:
        return hull[0], hull[0]
    if n == 2:
        return hull[0], hull[1]

    leftmost = 0
    for i in range(1, n):
        if hull[i][0] < hull[leftmost][0] or \
                (hull[i][0] == hull[leftmost][0] and hull[i][1] < hull[leftmost][1]):
            leftmost = i

    p1, p2 = leftmost, (leftmost + 1) % n
    max_dist = 0
    result = (hull[p1], hull[p2])

    for i in range(n):
        next_p1 = (p1 + 1) % n

        while True:
            next_p2 = (p2 + 1) % n
            area = cross(hull[p1], hull[next_p1], hull[next_p2]) - \
                   cross(hull[p1], hull[next_p1], hull[p2])

            if area <= 0:
                break
            p2 = next_p2

        dist = (hull[p1][0] - hull[p2][0]) ** 2 + (hull[p1][1] - hull[p2][1]) ** 2
        if dist > max_dist:
            max_dist = dist
            result = (hull[p1], hull[p2])

        p1 = next_p1

    return result

def solve():
    n = int(input())
    points = []
    for _ in range(n):
        x, y = map(int, input().split())
        points.append((x, y))

    hull = convex_hull(points)

    p1, p2 = rotating_calipers(hull)

    dx = p2[0] - p1[0]
    dy = p2[1] - p1[1]

    c1 = dx * p1[0] + dy * p1[1]
    c2 = dx * p2[0] + dy * p2[1]

    print(f"{-dx} {-dy} {c1}")
    print(f"{-dx} {-dy} {c2}")

solve()
