#include <iostream>
#include <cmath>
#include <iomanip>
#include <vector>
#include <algorithm>
using namespace std;

struct Point {
    double x, y;
};

double distance(Point a, Point b) {
    return sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

int main() {
    vector<Point> points(4);
    for (int i = 0; i < 4; i++) {
        cin >> points[i].x >> points[i].y;
    }
    
    // Находим ширину и высоту прямоугольника
    double width = distance(points[0], points[1]);
    double height = distance(points[1], points[2]);
    
    // Максимальный эллипс - окружность с диаметром min(width, height)
    double diameter = min(width, height);
    double area = M_PI * (diameter / 2.0) * (diameter / 2.0);
    
    cout << fixed << setprecision(8) << area << endl;
    return 0;
}