#include <iostream>
#include <string>
#include <vector>
#include <cmath>
using namespace std;

int getNoteValue(char note) {
    return note - 'A';
}

bool canPlay(const string& melody) {
    vector<int> positions = {0, 1, 2, 3, 4, 5, 6};
    
    for (int start : positions) {
        if (getNoteValue(melody[0]) != start % 7) continue;
        
        int current = start;
        bool valid = true;
        
        for (int i = 1; i < melody.size(); i++) {
            int target = getNoteValue(melody[i]);
            bool found = false;
            
            for (int delta = -3; delta <= 3; delta++) {
                int candidate = current + delta;
                if (candidate < 0) continue;
                if (candidate % 7 == target) {
                    current = candidate;
                    found = true;
                    break;
                }
            }
            
            if (!found) {
                valid = false;
                break;
            }
        }
        
        if (valid) return true;
    }
    
    return false;
}

int main() {
    int t;
    cin >> t;
    
    while (t--) {
        string melody;
        cin >> melody;
        
        if (canPlay(melody)) {
            cout << "Yes" << endl;
        } else {
            cout << "No" << endl;
        }
    }
    
    return 0;
}