#include <vector>
#include <iostream>

using namespace std;

using row = std::vector<int>;
using Gex = std::vector<row>;

void _t(row &r) {
    for (int i = 0; i < r.size() / 2; i++) {
        swap(r[i], r[r.size() - 1 - i]);
    }
}

void t(Gex &g) {
    for (int i = 0; i < g.size(); i++) {
        _t(g[i]);
    }
}

void _print(const row &r) {
    for (int i : r) {
        cout << i << " ";
    }
    cout << "\n";
}

void print(const Gex &g) {
    for (int i = 0; i < g.size(); i++) {
        _print(g[i]);
    }
}

Gex init(int n);

Gex lt(Gex &g) {
    int gs = (g.size() + 1) / 2;
    Gex n = init(gs);
    int rows = g.size();
    for (int i = 0; i < rows / 2 + 1; i++) {
        for (int j = 0; j < n[i].size(); j++) {
            int size = g[i].size();
            if (j < size - i) {
                n[i][j] = g[j][g[j].size() - 1 - i];
            } else {
                n[i][j] = g[j][rows - 1 - i];
            }
        }
    }
    for (int i = rows / 2 + 1; i < g.size(); i++) {
        int t = i - rows / 2;
        for (int j = 0; j < n[i].size(); j++) {
            int size = g[i].size();
            if (j < size - t - 1) {
                n[i][j] = g[j + t][j];
            } else {
                n[i][j] = g[j + t][gs - 1 - t];
            }
        }
    }
    return n;
}

Gex rt(Gex &g) {
    Gex n = g;
    for (int i = 0; i < 5; i++) {
        n = lt(n);
    }
    return n;
}

void _read(row& r) {
    for (int i = 0; i < r.size(); i++) {
        cin >> r[i];
    }
}

Gex init(int n) {
    Gex g;
    int rows = 2 * n - 1;
    for (int i = 0; i < rows / 2 + 1; i++) {
        row r(i + n);
        g.push_back(std::move(r));
    }
    for (int i = rows / 2; i > 0; i--) {
        row r(i + n - 1);
        g.push_back(std::move(r));
    }
    return g;
}

Gex read(int n) {
    Gex g = init(n);
    for (int i = 0; i < g.size(); i++) {
        _read(g[i]);
    }
    return g;
}

int main() {
    int n;
    cin >> n;
    Gex g = read(n);
    char c;
    while (cin >> c) {
        switch (c) {
            case 'L':
                g = lt(g);
                break;
            case 'R':
                g = rt(g);
                break;
            case 'T':
                t(g);
                break;
            default:
                goto br;
        }
    }
    br:
    print(g);
    return 0;
}