#include <vector>
#include <iostream>

using namespace std;

struct row {
    row() = default;
    row(vector<int> v) : _row(std::move(v)) {}

    int& operator[](int i) {
        if (r) {
            return _row[size() - 1 - i];
        }
        return _row[i];
    }

    size_t size() const {
        return _row.size();
    }

    void reverse() {
        r = !r;
    }
private:
    std::vector<int> _row;
    bool r = false;
};

struct Gex {
    Gex(vector<row> rows) : _rows(std::move(rows)) {}

    Gex(int n) : _rows(init(n)) {}

    void lt() {
        left_turns = (left_turns + 1) % 6;
    }

    void rt() {
        left_turns = (left_turns + 5) % 6;
    }

    size_t rows() {
        return _rows.size();
    }

    int n() {
        return (rows() + 1) / 2;
    }

    row& operator[](int i) {
        if (left_turns != 0) {
            throw 1;
        }
        return _rows[i];
    }

    void t() {
        reverse_before = !reverse_before;
        left_turns = 6 - left_turns;
    }

private:
    std::vector<row> _rows;
    int left_turns = 0;
    bool reverse_before = false;

private:
    static void _print(row &r) {
        for (int i = 0; i < r.size(); ++i) {
            cout << r[i] << " ";
        }
        cout << "\n";
    }

    static std::vector<row> init(int n) {
        std::vector<row> rs;
        const int rws = 2 * n - 1;
        rs.reserve(rws);
        for (int i = 0; i < rws / 2 + 1; i++) {
            row r(vector<int>(i + n));
            rs.push_back(std::move(r));
        }
        for (int i = rws / 2; i > 0; i--) {
            row r(vector<int>(i + n - 1));
            rs.push_back(std::move(r));
        }
        return rs;
    }

    static std::pair<int, int> get_coordinates_of_source_of_left_turn(Gex g, int i, int j) {
        int rows = g.rows();
        if (i < rows / 2 + 1) {
            int size = g[i].size();
            if (j < size - i) {
                return {j, g[j].size() - 1 - i};
            }
            return {j, rows - 1 - i};
        }
        int gs = (rows + 1) / 2;
        int t = i - rows / 2;
        if (j < gs - t - 1) {
            return {j + t, j};
        }
        return {j + t, gs - 1 - t};
    }

    static std::vector<row> apply_lt(std::vector<row> &g) {
        int rows = g.size();
        int gs = (rows + 1) / 2;
        std::vector<row> n = init(gs);
        for (int i = 0; i < rows; i++) {
            for (int j = 0; j < g[i].size(); j++) {
                auto [x, y] = get_coordinates_of_source_of_left_turn(g, i, j);
                n[i][j] = g[x][y];
            }
        }
        return n;
    }

public:
    void apply() {
        if (reverse_before) {
            for (int i = 0; i < rows(); i++) {
                _rows[i].reverse();
            }
        }
        while (left_turns != 0) {
            _rows = apply_lt(_rows);
            left_turns--;
        }
    }

    void print() {
        apply();
        for (int i = 0; i < rows(); i++) {
            _print(_rows[i]);
        }
    }

};

Gex read(int n) {
    Gex g(n);
    for (int i = 0; i < g.rows(); i++) {
        for (int j = 0; j < g[i].size(); j++) {
            cin >> g[i][j];
        }
    }
    return g;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    Gex g = read(n);
    char c;
    while (cin >> c) {
        switch (c) {
            case 'L':
                g.lt();
                break;
            case 'R':
                g.rt();
                break;
            case 'T':
                g.t();
                break;
            default:
                goto br;
        }
    }
    br:
    g.print();
    return 0;
}