#include <algorithm>
#include <bitset>
#include <chrono>
#include <climits>
#include <cmath>
#include <fstream>
#include <functional>
#include <iostream>
#include <list>
#include <map>
#include <numeric>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <complex>

using namespace std;

template<class T>
ostream &operator<<(ostream &out, const vector<T> &a) {
    for (auto &i: a) out << i << " ";
    return out;
}

template<class T>
T read() {
    T t;
    cin >> t;
    return t;
}

template<class T>
void operator>>(istream &in, vector<T> &a) { for (auto &i: a) in >> i; }

template<class T>
void operator>>(istream &in, vector<vector<T>> &a) { for (auto &i: a) in >> i; }

#define ll long long
#define ull unsigned ll
#define ld long double
#define M_PI 3.14159265358979323846
#define all(x) x.begin(), x.end()
#define rall(x) x.rbegin(), x.rend()
#define X first
#define Y second

const int MOD = 999983;
const double PI = acos(-1);

int stamp[MOD];

struct FFT {
    vector<int> rev;
    vector<complex<double>> roots;
    void init(int n) {
        int lg = 0;
        while ((1 << lg) < n) {
            ++lg;
        }

        rev.resize(n);
        for (int i = 0; i < n; ++i) {
            int x = i, y = 0;
            for (int j = 0; j < lg; ++j) {
                if (x & (1 << j)) {
                    y |= 1 << (lg - 1 - j);
                }
            }

            rev[i] = y;
        }

        roots.resize(n);
        for (int i = 0; i < n; ++i) {
            double ang = 2 * PI * i / n;
            roots[i] = complex<double>(cos(ang), sin(ang));
        }
    }

    void fft(vector<complex<double>> &a, bool inv) {
        int n = (int)a.size();
        if (n != rev.size()) {
            init(n);
        }

        for (int i = 0; i < n; ++i) {
            if (i < rev[i]) {
                swap(a[i], a[rev[i]]);
            }
        }

        for (int len = 1; len < n; len <<= 1) {
            int step = n / (len << 1);
            for (int i = 0; i < n; i += (len << 1)) {
                for (int j = 0; j < len; ++j) {
                    complex<double> u = a[i + j];
                    complex<double> v = a[i + j + len] * roots[step * j];
                    a[i + j] = u + v;
                    a[i + j + len] = u - v;
                }
            }
        }

        if (inv) {
            reverse(a.begin() + 1, a.end());
            for (int i = 0; i < n; ++i) {
                a[i] /= n;
            }
        }
    }
} FFTWorker;

vector<int> convolution(const vector<uint8_t> &arr, int last) {
    int need = last + 1;
    int n = 1;
    while (n < need * 2 - 1) {
        n <<= 1;
    }

    vector<complex<double>> fa(n);
    for (int i = 0; i < need; ++i) {
        fa[i] = complex<double>(arr[i], 0);
    }

    for (int i = need; i < n; ++i) {
        fa[i] = 0;
    }

    FFTWorker.fft(fa, false);
    for (int i = 0; i < n; ++i) {
        fa[i] *= fa[i];
    }

    FFTWorker.fft(fa, true);
    vector<int> res(need * 2 - 1);
    for (int i = 0; i < res.size(); ++i) {
        ll val = llround(fa[i].real());
        res[i] = (val & 3LL);
    }

    return res;
}

inline int calc_selfpair(int s, const vector<uint8_t> &p1) {
    if (s & 1) {
        return 0;
    }

    int a = s >> 1;
    if ((unsigned)a < (unsigned)MOD && p1[a]) {
        return 1;
    }

    return 0;
}

inline int calc_pairs(int s, const vector<int> &buf, const vector<int> &conv, const vector<uint8_t> &p2, int curStamp) {
    int ans = 0;
    if (!conv.empty() && (unsigned)s < conv.size()) {
        ans += conv[s];
    }

    for (auto&& v : buf) {
        int y = s - v;
        if ((unsigned)y < (unsigned)MOD && p2[y]) {
            ans += 2;
        }
    }

    for (auto&& v : buf) {
        int y = s - v;
        if (y < (unsigned)MOD && stamp[y] == curStamp) {
            ans += 1;
        }
    }

    return ans & 3;
}
void solution() {
    int n = read<int>();
    int s = read<int>();
    const int GOIDA = 512;
    vector<uint8_t> p1(MOD), p2(MOD);
    vector<int> buf;
    vector<int> conv;
    int curStamp = 1;
    int ans = 0;
    int maxP2 = -1;
    auto rebuild = [&]() {
        for (int x : buf) {
            if (!p2[x]) {
                p2[x] = 1;
                if (x > maxP2) {
                    maxP2 = x;
                }
            }
        }

        buf.clear();
        ++curStamp;
        if (curStamp == INT_MAX) {
            memset(stamp, 0, sizeof(stamp));
            curStamp = 1;
        }

        if (maxP2 < 0) {
            conv.clear();
            return;
        }

        conv = convolution(p2, maxP2);
    };

    for (int i = 0; i < n; ++i) {
        s = ((ll)s * 618023 + 1) % 999983;
        if (s < 0) s += 999983;

        int t = (calc_pairs(s, buf, conv, p2, curStamp) + calc_selfpair(s, p1)) & 3;
        if (t == 0) {
            if (!p1[s]) {
                p1[s] = 1;
                ++ans;
                buf.push_back(s);
                stamp[s] = curStamp;
                if (buf.size() > GOIDA) {
                    rebuild();
                }
            }
        }
    }

    cout << ans << '\n';
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
//    auto ttt = read<int>();
    auto ttt = 1;
    while (ttt--) solution();
}