#include <iostream>
#include <algorithm>
#include <vector>
#include <numbers>
#include <set>
#include <map>
#include <unordered_set>
#include <unordered_map>
#include <cmath>
#include <iomanip>

using namespace std;

using ll = long long;
using ld = long double;
using ull = unsigned long long;

const ll inf = 1e18;

vector<ll> a;

bool check(vector<ll> &path) {
    for (ll i = 0; i < a.size(); i++) {
        if (i < (a.size() - path[i] - 1) - a[path[i]]) {
            return false;
        }
    }
    return true;
}

bool dfs(vector<vector<ll>>& v, vector<ll> &path, set<ll> &used, ll cur) {
    if (used.find(cur) != used.end()) {
        return false;
    }
    
    used.insert(cur);
    path.push_back(cur);
    
    if (path.size() == v.size()) {
        if (check(path)) {
            for (auto x : path) {
                cout << x + 1 << " ";
            }
            cout << endl;
            return true;
        }
        used.erase(cur);
        path.pop_back();
        return false;
    }
    
    for (ll i = 0; i < v[cur].size(); i++) {
        if (dfs(v, path, used, v[cur][i])) {
            return true;
        }
    }
    
    used.erase(cur);
    path.pop_back();
    return false;
}


signed main() {
    ll n;
    cin >> n;
    vector<vector<ll>> v(n, vector<ll>());
    a.resize(n);
    for (ll i = 0; i < n; i++) {
        cin >> a[i];
    }
    for (ll i = n - 1; i >= 0; i--) {
        for (ll j = i - 1; j >= 0; j--) {
            v[i].push_back(j);
        }
        if (a[i] > 0) {
            for (ll j = i + 1; j < n; j++) {
                v[i].push_back(j);
            }
        }
    }

    
    for (ll i = 0; i < n; i++) {
        set<ll> used;
        vector<ll> path;
        if (dfs(v, path, used, i)) {
            return 0;
        }
    }
    return 0;
}