import sys
input = sys.stdin.readline

def read_hex(n):
    rows = []
    for _ in range(2 * n - 1):
        line = input().strip()
        if line == '':
            rows.append([])
        else:
            rows.append(list(map(int, line.split())))
    return rows

def build_coords_map(rows, n):
    r = n - 1
    coords = {}
    idx = 0
    z_vals = list(range(-r, r + 1))
    for i, z in enumerate(z_vals):
        x_min = max(-r, -z - r)
        x_max = min(r, -z + r)
        count = x_max - x_min + 1
        row = rows[idx] if idx < len(rows) else []
        if len(row) != count:
            if len(row) < count:
                row = row + [0] * (count - len(row))
            else:
                row = row[:count]
        j = 0
        for x in range(x_min, x_max + 1):
            y = -x - z
            coords[(x, y, z)] = row[j]
            j += 1
        idx += 1
    return coords

def coords_to_rows(coords, n):
    r = n - 1
    out_rows = []
    z_vals = list(range(-r, r + 1))
    for z in z_vals:
        x_min = max(-r, -z - r)
        x_max = min(r, -z + r)
        row = []
        for x in range(x_min, x_max + 1):
            y = -x - z
            row.append(coords[(x, y, z)])
        out_rows.append(row)
    return out_rows

def reflect_T_rows(rows):
    return [list(reversed(row)) for row in rows]

def rotate_R_coords(coords):
    return {(-z, -x, -y): v for (x, y, z), v in coords.items()}

def rotate_L_coords(coords):
    return {(-y, -z, -x): v for (x, y, z), v in coords.items()}

def main():
    n_line = input().strip()
    while n_line == '':
        n_line = input().strip()
    n = int(n_line)
    rows = []
    for _ in range(2 * n - 1):
        rows.append(list(map(int, input().split())))
    ops = input().strip()
    coords = build_coords_map(rows, n)
    for op in ops:
        if op == 'T':
            tmp_rows = coords_to_rows(coords, n)
            tmp_rows = reflect_T_rows(tmp_rows)
            coords = build_coords_map(tmp_rows, n)
        elif op == 'R':
            coords = rotate_R_coords(coords)
        elif op == 'L':
            coords = rotate_L_coords(coords)
    result_rows = coords_to_rows(coords, n)
    out = []
    for row in result_rows:
        out.append(' '.join(map(str, row)))
    sys.stdout.write('\n'.join(out))

if __name__ == "__main__":
    main()
