import math

def my_int():
    n = int(input())
    points = []
    for i in range(n):
        x, y = input().split()
        points.append((int(x), int(y)))
    return points

def main():
    points = my_int()
    n = len(points)
    if n < 2:
        print("1 0 0")
        print("1 0 0")
        return

    best = -1
    l = r = 0
    for i in range(n):
        x1, y1 = points[i]
        for j in range(i + 1, n):
            x2, y2 = points[j]
            dx = x2 - x1
            dy = y2 - y1
            d2 = dx * dx + dy * dy
            if d2 > best:
                best = d2
                l, r = i, j

    x1, y1 = points[l]
    x2, y2 = points[r]
    x3 = x2 - x1
    y3 = y2 - y1

    a = -(x3 * x1 + y3 * y1)
    b = -(x3 * x2 + y3 * y2)

    g = math.gcd(x3, y3)
    g = math.gcd(g, a)
    if g == 0:
        g = 1
    x0, y0, x10, y10 = x3 // g, y3 // g, a // g, b // g
    print(f"{x0} {y0} {x10}")
    print(f"{x0} {y0} {y10}")

if __name__ == "__main__":
    main()
