#include <bits/stdc++.h>
using namespace std;

static inline bool is_one(const string& s){ return s=="1"; }
static inline bool is_even(const string& s){ return ((s.back()-'0') & 1) == 0; }
static inline int digits(const string& s){ return (int)s.size(); }

static unsigned v2_cap(const string& s, unsigned cap){
    unsigned M = 1u << cap, rem = 0;
    for(char c: s) rem = (rem * 10u + (unsigned)(c - '0')) % M;
    if(rem == 0) return cap;
    unsigned k = 0;
    while(k < cap && ((rem >> k) & 1u) == 0u) ++k;
    return k;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    const int MAX_LEN_FOR_BLUE = 5;
    const unsigned NEED_V2 = 6;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        while(true){
            if(is_one(x)) break;

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                continue;
            }

            bool tried_blue = false;

            if(digits(x) <= MAX_LEN_FOR_BLUE){
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                tried_blue = true;
                if(is_one(x)) continue;

                if(is_even(x) || v2_cap(x, 12) >= NEED_V2){
                    while(!is_one(x) && is_even(x)){
                        cout << "collatz\n" << flush;
                        if(!(cin >> x)) return 0;
                        if(x == "0") return 0;
                    }
                    continue;
                }
            }

            cout << "collatz\n" << flush;
            if(!(cin >> x)) return 0;
            if(x == "0") return 0;

            while(!is_one(x) && is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
            }
        }
    }
    return 0;
}
