#include <bits/stdc++.h>
using namespace std;

static inline bool is_even(const string& s){
    return !s.empty() && ((s.back()-'0')%2==0);
}

static inline int mod_pow2(const string& s, int k){
    int m = 1<<k, r = 0;
    for(char c: s){
        if(c>='0' && c<='9') r = (r*10 + (c-'0')) % m;
    }
    return r;
}

static inline int target_k(size_t len){
    if(len<=3) return 6;
    if(len<=6) return 10;
    if(len<=9) return 12;
    if(len<=12) return 14;
    return 16;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin>>t)) return 0;

    for(int round=0; round<t; ++round){
        string x;
        if(!(cin>>x)) return 0;

        while(true){
            if(x=="0") return 0;
            if(x=="1") break;

            if(is_even(x)){
                cout<<"collatz\n"<<flush;
                if(!(cin>>x)) return 0;
                continue;
            }

            int k = target_k(x.size());
            bool progressed = false;

            for(int tries=0; tries<48; ++tries){
                cout<<"random\n"<<flush;
                if(!(cin>>x)) return 0;
                if(x=="0") return 0;
                if(x=="1"){ progressed = true; break; }
                if(mod_pow2(x,k)==0){ progressed = true; break; }
                if(is_even(x) && tries>=2) break;
            }

            if(x=="1") break;
            if(x=="0") return 0;

            if(!progressed && !is_even(x)){
                cout<<"collatz\n"<<flush;
                if(!(cin>>x)) return 0;
            }
        }
    }
    return 0;
}
