import java.io.BufferedInputStream
import java.io.PrintWriter

private class FastScanner {
    private val input = BufferedInputStream(System.`in`)
    private val buffer = ByteArray(1 shl 16)
    private var len = 0
    private var ptr = 0

    private fun readByte(): Int {
        if (ptr >= len) {
            len = input.read(buffer)
            ptr = 0
            if (len < 0) return -1
        }
        return buffer[ptr++].toInt()
    }

    fun nextLong(): Long {
        var c = readByte()
        while (c <= 32 && c >= 0) c = readByte()
        var sign = 1
        if (c == '-'.code) {
            sign = -1
            c = readByte()
        }
        var res = 0L
        while (c > 32) {
            res = res * 10 + (c - '0'.code)
            c = readByte()
        }
        return if (sign == 1) res else -res
    }
}

fun main() {
    val fs = FastScanner()
    val n = fs.nextLong()
    val p = fs.nextLong()

    val num = n * p * 55L
    val intPart = num / 1000L
    val fracPart = num % 1000L

    val out = PrintWriter(System.out)
    if (fracPart == 0L) {
        out.println(intPart)
    } else {
        var fracStr = String.format("%03d", fracPart)
        while (fracStr.endsWith("0")) {
            fracStr = fracStr.substring(0, fracStr.length - 1)
        }
        out.println("$intPart.$fracStr")
    }
    out.flush()
}
