import sys
import math

def solve_f():
    input_data = sys.stdin.read().split()
    
    if not input_data:
        return

    n = int(input_data[0])
    points = []

    for i in range(n):
        x = int(input_data[2 * i + 1])
        y = int(input_data[2 * i + 2])
        points.append((x, y))

    max_area = 0.0

    for i in range(n):
        for j in range(i + 1, n):
            for k in range(j + 1, n):
                x1, y1 = points[i]
                x2, y2 = points[j]
                x3, y3 = points[k]

                double_area = abs(x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2))

                if double_area / 2.0 > max_area:
                    max_area = double_area / 2.0

    sys.stdout.write(f"{max_area:.2f}\n") 
