import java.io.*;

public class WhoYa {
    static class FastScanner {
        private final InputStream in;
        private final byte[] buf = new byte[1 << 16];
        private int ptr = 0, len = 0;
        FastScanner(InputStream is) { in = is; }
        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buf);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buf[ptr++];
        }
        int nextInt() throws IOException {
            int c;
            do c = read(); while (c <= 32 && c != -1);
            int sign = 1;
            if (c == '-') { sign = -1; c = read(); }
            int x = 0;
            while (c > 32) {
                x = x * 10 + (c - '0');
                c = read();
            }
            return x * sign;
        }
    }

    static int mexFromArray(int[] arr) {
        int n = arr.length;
        boolean[] seen = new boolean[n + 2];
        for (int v : arr) {
            if (v >= 1 && v <= n + 1) {
                seen[v] = true;
            }
        }
        for (int x = 1; x <= n + 1; x++) {
            if (!seen[x]) return x;
        }
        return n + 2;
    }

    public static void main(String[] args) throws Exception {
        FastScanner fs = new FastScanner(System.in);

        int mode = fs.nextInt();
        int n = fs.nextInt();
        int[] a = new int[n];
        int maxVal = 0;
        for (int i = 0; i < n; i++) {
            a[i] = fs.nextInt();
            if (a[i] > maxVal) maxVal = a[i];
        }

        if (mode == 0) {
            int limit = Math.max(n + 2, maxVal + 2);
            int[] freq = new int[limit];
            for (int v : a) freq[v]++;

            int mexAll = 1;
            while (mexAll < limit && freq[mexAll] > 0) mexAll++;

            int ansIdx = 1;
            int bestVal = -1;

            for (int i = 0; i < n; i++) {
                int v = a[i];
                int candMex;
                if (v < mexAll && freq[v] == 1) {
                    candMex = v;
                } else {
                    candMex = mexAll;
                }
                if (candMex == v) {
                    if (v > bestVal) {
                        bestVal = v;
                        ansIdx = i + 1;
                    }
                }
            }

            System.out.println(ansIdx);

        } else {
            int guess = mexFromArray(a);
            System.out.println(guess);
        }
    }
}
