import java.io.*;

public class Kolatz {
    public static void main(String[] args) throws Exception {
        FastScanner in = new FastScanner(System.in);
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)), true);

        String tLine = in.nextToken();
        if (tLine == null) return;
        int t = Integer.parseInt(tLine);

        for (int round = 0; round < t; round++) {
            String cur = in.nextToken();
            if (cur == null) return;

            boolean firstStep = true;

            while (true) {
                if (cur.equals("0")) return;
                if (cur.equals("1")) break;

                long x = parseLongSafe(cur);
                boolean isOdd = isOddString(cur);

                String action;
                if (firstStep) {
                    if (isOdd && x != Long.MAX_VALUE && x <= 1_000_000L) {
                        action = "random";
                    } else {
                        action = "collatz";
                    }
                    firstStep = false;
                } else {
                    action = "collatz";
                }

                out.println(action);
                out.flush();

                String nxt = in.nextToken();
                if (nxt == null) return;
                cur = nxt;
            }
        }
    }

    static boolean isOddString(String s) {
        char c = s.charAt(s.length() - 1);
        return (c & 1) == 1;
    }

    static long parseLongSafe(String s) {
        if (s.length() > 18) return Long.MAX_VALUE;
        long v = 0L;
        for (int i = 0; i < s.length(); i++) {
            int d = s.charAt(i) - '0';
            if (d < 0 || d > 9) return Long.MAX_VALUE;
            long nv = v * 10L + d;
            if (nv < v) return Long.MAX_VALUE;
            v = nv;
        }
        return v;
    }

    static class FastScanner {
        private final InputStream in;
        private final byte[] buf = new byte[1 << 16];
        private int ptr = 0, len = 0;

        FastScanner(InputStream is) { in = is; }

        String nextToken() throws IOException {
            StringBuilder sb = new StringBuilder();
            int c;
            while (true) {
                c = read();
                if (c == -1) return sb.length() == 0 ? null : sb.toString();
                if (c > 32) break;
            }
            while (c > 32) {
                sb.append((char)c);
                c = read();
            }
            return sb.toString();
        }

        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buf);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buf[ptr++];
        }
    }
}
