import java.io.*;
import java.util.*;

public class summ_dvuh {
    static final int MOD = 999_983;
    static final long MUL = 618_023L;
    static final int BLOCK = 1024;
    static final int MAX_SUM = MOD * 2;

    static class FastScanner {
        private final InputStream in;
        private final byte[] buf = new byte[1 << 16];
        private int ptr = 0, len = 0;
        FastScanner(InputStream is) { in = is; }
        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buf);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buf[ptr++];
        }
        int nextInt() throws IOException {
            int c;
            do c = read(); while (c <= 32 && c != -1);
            int sign = 1;
            if (c == '-') { sign = -1; c = read(); }
            int x = 0;
            while (c > 32) {
                x = x * 10 + (c - '0');
                c = read();
            }
            return x * sign;
        }
    }

    public static void main(String[] args) throws Exception {
        FastScanner fs = new FastScanner(System.in);
        int n = fs.nextInt();
        int s = fs.nextInt();

        boolean[] inHeavy = new boolean[MOD];
        boolean[] inSmall = new boolean[MOD];
        int[] smallList = new int[BLOCK * 2];
        int smallSize = 0;

        long[] heavyBits = new long[(MOD + 63) >>> 6];

        byte[] parityHeavy = new byte[MAX_SUM];
        byte[] paritySmall = new byte[MAX_SUM];

        int setSize = 0;

        for (int step = 0; step < n; step++) {
            s = (int)((s * MUL + 1) % MOD);

            int sumParity = 0;

            int half = s >> 1;
            if ((s & 1) == 0) {
                if (inHeavy[half] || inSmall[half]) sumParity ^= 1;
            }

            int pSmallSmall = paritySmall[s] & 1;
            sumParity ^= pSmallSmall;

            int pHeavyHeavy = parityHeavy[s] & 1;
            sumParity ^= pHeavyHeavy;

            int hsParity = 0;
            for (int i = 0; i < smallSize; i++) {
                int x = smallList[i];
                int y = s - x;
                if (y < 0 || y >= MOD) continue;
                if (y == x) {
                    if (inHeavy[x]) hsParity ^= 1;
                } else {
                    if (inHeavy[y]) hsParity ^= 1;
                }
            }
            sumParity ^= hsParity;

            if (sumParity == 0) {
                if (!inHeavy[s] && !inSmall[s]) {
                    for (int i = 0; i < smallSize; i++) {
                        int x = smallList[i];
                        int y = x + s;
                        if (y < MAX_SUM) {
                            paritySmall[y] ^= 1;
                        }
                    }
                    paritySmall[s + s] ^= 1;

                    inSmall[s] = true;
                    if (smallSize == smallList.length) {
                        smallList = Arrays.copyOf(smallList, smallList.length * 2);
                    }
                    smallList[smallSize++] = s;
                    setSize++;

                    if (smallSize >= BLOCK) {
                        for (int i = 0; i < smallSize; i++) {
                            int x = smallList[i];
                            int word = x >>> 6;
                            long mask = 1L << (x & 63);
                            heavyBits[word] |= mask;
                            inHeavy[x] = true;
                        }

                        for (int i = 0; i < smallSize; i++) {
                            int a = smallList[i];
                            for (int j = i; j < smallSize; j++) {
                                int b = smallList[j];
                                int y = a + b;
                                if (y < MAX_SUM) {
                                    parityHeavy[y] ^= 1;
                                }
                            }
                        }

                        for (int i = 0; i < smallSize; i++) {
                            int x = smallList[i];
                            inSmall[x] = false;
                        }
                        Arrays.fill(paritySmall, (byte)0);
                        smallSize = 0;
                    }
                }
            }
        }

        System.out.println(setSize);
    }
}
