#include <iostream>
#include <vector>
#include <algorithm>

static int booth_min_rotation(const std::vector<int>& s) {
    int n = (int)s.size();
    if (n == 0) return 0;
    std::vector<int> ss(2 * n);
    for (int i = 0; i < 2 * n; ++i) ss[i] = s[i % n];

    int i = 0, j = 1, k = 0;
    while (i < n && j < n && k < n) {
        int a = ss[i + k];
        int b = ss[j + k];
        if (a == b) {
            ++k;
        }
        else if (a > b) {
            i = i + k + 1;
            if (i <= j) i = j + 1;
            k = 0;
        }
        else {
            j = j + k + 1;
            if (j <= i) j = i + 1;
            k = 0;
        }
    }
    return std::min(i, j);
}

int main() {
    long long first;
    if (!(std::cin >> first)) return 0;

    if (first == 0) {
        int n;
        std::cin >> n;
        std::vector<int> a(n);
        for (int i = 0; i < n; ++i) std::cin >> a[i];

        int r = booth_min_rotation(a); 
        int p = r + 1; 
        std::cout << p << "\n";
    }
    else {
        int p = (int)first;
        int m;
        std::cin >> m;
        std::vector<int> b(m);
        for (int i = 0; i < m; ++i) std::cin >> b[i];

        int n = m + 1;
        int start_offset = p % n;
        int expected_r = p - 1;     

        int answer = 1;
        for (int x = 1; x <= n; ++x) {
            std::vector<int> s;
            s.reserve(n);
            for (int v : b) s.push_back(v);
            s.push_back(x); 
            int local_start = booth_min_rotation(s); 
            int r_global = (start_offset + local_start) % n;
            if (r_global == expected_r) {
                answer = x;
                break;
            }
        }
        std::cout << answer << "\n";
    }
    return 0;
}
